package yangtz.cs.liu.campus.service.impl.schoolAssetsClaim;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import yangtz.cs.liu.campus.domain.schoolAssetsClaim.SchoolAssetsClaim;
import yangtz.cs.liu.campus.mapper.schoolAssetsClaim.SchoolAssetsClaimMapper;
import yangtz.cs.liu.campus.service.schoolAssetsClaim.ISchoolAssetsClaimService;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.AssetsClaimListVo;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.ClaimVo;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.AssetsClaimDetailsVo;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.SchoolAssetsClaimVo;

import java.util.ArrayList;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNull;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@Service
public class SchoolAssetsClaimServiceImpl extends ServiceImpl<SchoolAssetsClaimMapper, SchoolAssetsClaim> implements ISchoolAssetsClaimService
{
    @Autowired
    private SchoolAssetsClaimMapper schoolAssetsClaimMapper;
    @Autowired
    private SysUserMapper userMapper;

    @Override
    public List<AssetsClaimListVo> queryList(SchoolAssetsClaimVo schoolAssetsClaimVo) {
        List<AssetsClaimListVo> list = new ArrayList<>();
        LambdaQueryWrapper<SchoolAssetsClaim> lqw = new LambdaQueryWrapper<>();
        lqw.like(isNotNull(schoolAssetsClaimVo.getAssetsName()),SchoolAssetsClaim::getAssetsName,schoolAssetsClaimVo.getAssetsName())
                .orderByDesc(SchoolAssetsClaim::getCreateTime);
        List<SchoolAssetsClaim> claims = schoolAssetsClaimMapper.selectList(lqw);
        if(StringUtils.isNull(claims) || claims.size() == 0){
            return list;
        }
        for (SchoolAssetsClaim claim : claims){
            AssetsClaimListVo vo = new AssetsClaimListVo();
            BeanUtils.copyProperties(claim,vo);
            SysUser user = userMapper.selectUserById(claim.getCollectBy());
            if(StringUtils.isNotNull(user)){
                vo.setCollectByName(user.getUserName());
            }
            list.add(vo);
        }
        return list;
    }

    @Override
    public List<AssetsClaimListVo> queryMyClaimList(Long userId, SchoolAssetsClaimVo schoolAssetsClaimVo) {
        //List<AssetsClaimListVo> list = new ArrayList<>();
        List<AssetsClaimListVo> claims = schoolAssetsClaimMapper.queryMyClaimList(userId,schoolAssetsClaimVo);
        if(StringUtils.isNull(claims) || claims.size() == 0){
            return claims;
        }
        for (AssetsClaimListVo claim : claims){
            /*AssetsClaimListVo vo = new AssetsClaimListVo();
            BeanUtils.copyProperties(claim,vo);*/
            SysUser user = userMapper.selectUserById(claim.getCollectBy());
            if(StringUtils.isNotNull(user)){
                claim.setCollectByName(user.getUserName());
            }
        }
        return claims;
    }

    @Override
    public List<AssetsClaimListVo> queryDeptClaimList(Long deptId, SchoolAssetsClaimVo schoolAssetsClaimVo) {
        //List<AssetsClaimListVo> list = new ArrayList<>();
        List<AssetsClaimListVo> claims = schoolAssetsClaimMapper.queryDeptClaimList(deptId,schoolAssetsClaimVo);
        if(StringUtils.isNull(claims) || claims.size() == 0){
            return claims;
        }
        for (AssetsClaimListVo claim : claims){
            SysUser user = userMapper.selectUserById(claim.getCollectBy());
            if(StringUtils.isNotNull(user)){
                claim.setCollectByName(user.getUserName());
            }
        }
        return claims;
    }

    //新增
    @Override
    public int saveClaims(ClaimVo vo) {
        int num = 0;
        for(AssetsClaimDetailsVo assetsClaimDetailsVo : vo.getList()){
            //空数据
            if(assetsClaimDetailsVo.getAssetsId().equals("") && assetsClaimDetailsVo.getAssetsName().equals("")
                    && assetsClaimDetailsVo.getAssetsUnit().equals("") && assetsClaimDetailsVo.getAssetsAttribute().equals(""))
            {
                continue;
            }
            SchoolAssetsClaim claim = new SchoolAssetsClaim();
            BeanUtils.copyProperties(vo,claim);
            claim.setAssetsId(assetsClaimDetailsVo.getAssetsId());
            claim.setAssetsName(assetsClaimDetailsVo.getAssetsName());
            claim.setAssetsSpecs(assetsClaimDetailsVo.getAssetsSpecs());
            claim.setAssetsNumbers(assetsClaimDetailsVo.getAssetsNumbers());
            claim.setAssetsUnit(assetsClaimDetailsVo.getAssetsUnit());
            claim.setAssetsAttribute(assetsClaimDetailsVo.getAssetsAttribute());
            claim.setDepositPlace(assetsClaimDetailsVo.getDepositPlace());
            claim.setRemark(assetsClaimDetailsVo.getRemark());
            claim.setState("0");
            num += schoolAssetsClaimMapper.insert(claim);
        }
        return num == vo.getList().size() ? 1 : 0;
    }

//    /**
//     * 查询【请填写功能名称】
//     *
//     * @param id 【请填写功能名称】主键
//     * @return 【请填写功能名称】
//     */
//    @Override
//    public SchoolAssetsClaim selectSchoolAssetsClaimById(Long id)
//    {
//        return schoolAssetsClaimMapper.selectSchoolAssetsClaimById(id);
//    }
//
//    /**
//     * 查询【请填写功能名称】列表
//     *
//     * @param schoolAssetsClaim 【请填写功能名称】
//     * @return 【请填写功能名称】
//     */
//    @Override
//    public List<SchoolAssetsClaim> selectSchoolAssetsClaimList(SchoolAssetsClaim schoolAssetsClaim)
//    {
//        return schoolAssetsClaimMapper.selectSchoolAssetsClaimList(schoolAssetsClaim);
//    }
//
//    /**
//     * 新增【请填写功能名称】
//     *
//     * @param schoolAssetsClaim 【请填写功能名称】
//     * @return 结果
//     */
//    @Override
//    public int insertSchoolAssetsClaim(SchoolAssetsClaim schoolAssetsClaim)
//    {
//        schoolAssetsClaim.setCreateTime(DateUtils.getNowDate());
//        return schoolAssetsClaimMapper.insertSchoolAssetsClaim(schoolAssetsClaim);
//    }
//
//    /**
//     * 修改【请填写功能名称】
//     *
//     * @param schoolAssetsClaim 【请填写功能名称】
//     * @return 结果
//     */
//    @Override
//    public int updateSchoolAssetsClaim(SchoolAssetsClaim schoolAssetsClaim)
//    {
//        schoolAssetsClaim.setUpdateTime(DateUtils.getNowDate());
//        return schoolAssetsClaimMapper.updateSchoolAssetsClaim(schoolAssetsClaim);
//    }
//
//    /**
//     * 批量删除【请填写功能名称】
//     *
//     * @param ids 需要删除的【请填写功能名称】主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolAssetsClaimByIds(Long[] ids)
//    {
//        return schoolAssetsClaimMapper.deleteSchoolAssetsClaimByIds(ids);
//    }
//
//    /**
//     * 删除【请填写功能名称】信息
//     *
//     * @param id 【请填写功能名称】主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolAssetsClaimById(Long id)
//    {
//        return schoolAssetsClaimMapper.deleteSchoolAssetsClaimById(id);
//    }
}
