package yangtz.cs.liu.campus.service.impl.repairs;

import java.util.List;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.mapper.repairs.LogisticsRepairsMapper;
import yangtz.cs.liu.campus.domain.repairs.LogisticsRepairs;
import yangtz.cs.liu.campus.service.repairs.ILogisticsRepairsService;

/**
 * 后勤报修Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@Service
public class LogisticsRepairsServiceImpl implements ILogisticsRepairsService
{
    @Autowired
    private LogisticsRepairsMapper logisticsRepairsMapper;
    @Autowired
    private UserInfoUtil userInfoUtil;
    @Value("${ruoyi.serverAddress}")
    private String serverAddress;

    /**
     * 查询后勤报修
     *
     * @param id 后勤报修主键
     * @return 后勤报修
     */
    @Override
    public LogisticsRepairs selectLogisticsRepairsById(Long id)
    {
        LogisticsRepairs logisticsRepairs = logisticsRepairsMapper.selectLogisticsRepairsById(id);
        if (null != logisticsRepairs.getFailureEquipmentPicture() && !"".equals(logisticsRepairs.getFailureEquipmentPicture())){
            String[] split = logisticsRepairs.getFailureEquipmentPicture().split(",");
            String pic = "";
            for (int i = 0; i < split.length; i++) {
                if (i == split.length - 1){
                    pic += serverAddress + split[i];
                }else {
                    pic += serverAddress + split[i] + ",";
                }
            }
            logisticsRepairs.setNewFailureEquipmentPicture(pic);
        }
        return logisticsRepairs;
    }

    /**
     * 查询个人后勤报修列表
     *
     * @param logisticsRepairs 后勤报修
     * @return 后勤报修
     */
    @Override
    public List<LogisticsRepairs> selectLogisticsRepairsList(LogisticsRepairs logisticsRepairs)
    {
        //获取当前登录人id
        logisticsRepairs.setRepairsId(SecurityUtils.getLoginUser().getUser().getUserId());
        return logisticsRepairsMapper.selectLogisticsRepairsList(logisticsRepairs);
    }

    /**
     * 新增后勤报修
     *
     * @param logisticsRepairs 后勤报修
     * @return 结果
     */
    @Override
    public int insertLogisticsRepairs(LogisticsRepairs logisticsRepairs)
    {
        //获取当前登录人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //设置报修人id
        logisticsRepairs.setRepairsId(user.getUserId());
        //设置报修人
        logisticsRepairs.setRepairsName(user.getUserName());
        //设置报修人联系方式
        logisticsRepairs.setPhone(Long.parseLong(user.getPhonenumber()));
        logisticsRepairs.setCreateBy(user.getUserName());
        logisticsRepairs.setCreateTime(DateUtils.getNowDate());
        return logisticsRepairsMapper.insertLogisticsRepairs(logisticsRepairs);
    }

    @Override
    public int insertRepairs(LogisticsRepairs logisticsRepairs) {
        //设置报修人id
        logisticsRepairs.setRepairsId(userInfoUtil.getTeacherId());
        //设置报修人
        logisticsRepairs.setRepairsName(userInfoUtil.getTeacherName());
        //设置报修人联系方式
        logisticsRepairs.setPhone(Long.parseLong(userInfoUtil.getMpLoginUser().getTeacherPhonenumber()));
        logisticsRepairs.setCreateBy(userInfoUtil.getTeacherName());
        logisticsRepairs.setCreateTime(DateUtils.getNowDate());
        return logisticsRepairsMapper.insertLogisticsRepairs(logisticsRepairs);
    }

    /**
     * 修改后勤报修
     *
     * @param logisticsRepairs 后勤报修
     * @return 结果
     */
    @Override
    public int updateLogisticsRepairs(LogisticsRepairs logisticsRepairs)
    {
        logisticsRepairs.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        logisticsRepairs.setUpdateTime(DateUtils.getNowDate());
        return logisticsRepairsMapper.updateLogisticsRepairs(logisticsRepairs);
    }

    @Override
    public int updateRepairs(LogisticsRepairs logisticsRepairs) {
        String teacherName = userInfoUtil.getTeacherName();
        logisticsRepairs.setUpdateBy(teacherName);
        logisticsRepairs.setUpdateTime(DateUtils.getNowDate());
        return logisticsRepairsMapper.updateLogisticsRepairs(logisticsRepairs);
    }

    /**
     * 批量删除后勤报修
     *
     * @param ids 需要删除的后勤报修主键
     * @return 结果
     */
    @Override
    public int deleteLogisticsRepairsByIds(Long[] ids)
    {
        return logisticsRepairsMapper.deleteLogisticsRepairsByIds(ids);
    }

    /**
     * 删除后勤报修信息
     *
     * @param id 后勤报修主键
     * @return 结果
     */
    @Override
    public int deleteLogisticsRepairsById(Long id)
    {
        return logisticsRepairsMapper.deleteLogisticsRepairsById(id);
    }

    /**
     * 查询所有后勤报修信息
     * @param logisticsRepairs
     * @return
     */
    @Override
    public List<LogisticsRepairs> selectListAll(LogisticsRepairs logisticsRepairs) {
        return logisticsRepairsMapper.selectLogisticsRepairsList(logisticsRepairs);
    }

    @Override
    public List<LogisticsRepairs> selectListRepairs(LogisticsRepairs logisticsRepairs) {
        return logisticsRepairsMapper.selectListRepairs(logisticsRepairs);
    }

    /**
     * 查看个人报修列表
     * @param userId
     * @param logisticsRepairs
     * @return
     */
    @Override
    public List<LogisticsRepairs> getList(Long userId, LogisticsRepairs logisticsRepairs) {
        List<LogisticsRepairs> list = logisticsRepairsMapper.getList(userId,logisticsRepairs);
        return list;
    }
}
