package yangtz.cs.liu.campus.service.impl.recipe;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.utils.LogfieldUtil;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanValidators;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.recipe.SchoolRecipes;
import yangtz.cs.liu.campus.mapper.recipe.SchoolRecipesMapper;
import yangtz.cs.liu.campus.service.recipe.ISchoolRecipesService;
import yangtz.cs.liu.campus.vo.recipeVo.recipeVo;

import javax.validation.Validator;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 学校每日食谱Service业务层处理
 *
 * @author ruoyi
 * @date 2022-10-05
 */
@Service
public class SchoolRecipesServiceImpl extends ServiceImpl<SchoolRecipesMapper, SchoolRecipes> implements ISchoolRecipesService {
    @Autowired
    private SchoolRecipesMapper schoolRecipesMapper;

    @Override
    public List<SchoolRecipes> queryList(SchoolRecipes schoolRecipes) {
        LambdaQueryWrapper<SchoolRecipes> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolRecipes.getDate()), SchoolRecipes::getDate, schoolRecipes.getDate())//食谱日期
                .like(isNotBlank(schoolRecipes.getBreakfast()), SchoolRecipes::getBreakfast, schoolRecipes.getBreakfast())//早餐
                .like(isNotBlank(schoolRecipes.getLunch()), SchoolRecipes::getLunch, schoolRecipes.getLunch())//午餐
                .like(isNotBlank(schoolRecipes.getDinner()), SchoolRecipes::getDinner, schoolRecipes.getDinner())//晚餐
                .orderByDesc(SchoolRecipes::getDate)//
        ;
        return schoolRecipesMapper.selectList(lqw);
    }


    @Override
    public void check(List<SchoolRecipes> list) {
        // 检验是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for (SchoolRecipes schoolRecipes : list) {
            if (StringUtils.isEmpty(schoolRecipes.getBreakfast())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、早餐未输入，请您重新输入!");
            } else if (StringUtils.isEmpty(schoolRecipes.getLunch())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、午餐未输入，请您重新输入!");
            } else if (StringUtils.isEmpty(schoolRecipes.getDinner())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、晚餐未输入，请您重新输入!");
            } else if (schoolRecipes.getDate() == null) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "数据缺少日期，请您重新输入");
            } else if (isNotNull(schoolRecipes.getDate())) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date schoolRecipesDate = schoolRecipes.getDate();
                    sdf.format(schoolRecipesDate);
                } catch (Exception e) {
                    throw new ServiceException("格式不对，请检查日期格式");
                }

            }
        }
    }


    @Autowired
    protected Validator validator;

    @Override
    public String importData(List<SchoolRecipes> list) {
        // 准备记录日志数据
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        for (SchoolRecipes schoolRecipes : list) {
            try {
                // 验证是否存在这个日期
                List<recipeVo> recipeVoList = schoolRecipesMapper.selectDate(schoolRecipes.getDate());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sdf.format(schoolRecipes.getDate());
                if (StringUtils.isNull(recipeVoList) || recipeVoList.size() == 0) {
                    schoolRecipesMapper.insertRecipes(schoolRecipes);
                    successNum++;
                    successMsg.append("<br/>" + successNum + "食谱" + " 导入成功");
                } else {
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + ":"+ format + " 的食谱已存在");
                }
            } catch (Exception e) {
                failureNum++;
                String msg = "<br>" + failureNum + "、食谱" + " 导入失败：";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, e);
                throw new ServiceException("导入失败");
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException("<br>" + failureMsg);
        }else {
            successMsg.insert(0, "恭喜您，数据已导入成功！共有 " + successNum + " 条，数据如下：");
            return successMsg.toString();
        }
    }

}
