package yangtz.cs.liu.campus.service.impl.patrol;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolRuleDetails;
import yangtz.cs.liu.campus.mapper.patrol.SchoolPatrolRuleDetailsMapper;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolRuleDetailsService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolPatrolRuleDetailsServiceImpl extends ServiceImpl<SchoolPatrolRuleDetailsMapper, SchoolPatrolRuleDetails> implements ISchoolPatrolRuleDetailsService {

    @Autowired
    private SchoolPatrolRuleDetailsMapper schoolPatrolRuleDetailsMapper;

    @Override
    public List<SchoolPatrolRuleDetails> queryList(SchoolPatrolRuleDetails schoolPatrolRuleDetails) {
        LambdaQueryWrapper<SchoolPatrolRuleDetails> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolPatrolRuleDetails.getContent()),SchoolPatrolRuleDetails::getContent,schoolPatrolRuleDetails.getContent())
                .eq(isNotNull(schoolPatrolRuleDetails.getRuleId()), SchoolPatrolRuleDetails::getRuleId, schoolPatrolRuleDetails.getRuleId())
                .eq(isNotNull(schoolPatrolRuleDetails.getSort()),SchoolPatrolRuleDetails::getSort,schoolPatrolRuleDetails.getSort())
                .orderByAsc(SchoolPatrolRuleDetails::getSort);
        return schoolPatrolRuleDetailsMapper.selectList(lqw);
    }
}
