package yangtz.cs.liu.campus.service.impl.introduce;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.introduce.SchoolIntroduce;
import yangtz.cs.liu.campus.domain.introduce.SchoolPic;
import yangtz.cs.liu.campus.mapper.introduce.SchoolPicMapper;
import yangtz.cs.liu.campus.service.introduce.ISchoolPicService;



import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
/**
 * 园区照片Service业务层处理
 *
 */
@Service
public class SchoolPicServiceImpl extends ServiceImpl<SchoolPicMapper, SchoolPic> implements ISchoolPicService
{
    @Autowired
    private SchoolPicMapper schoolPicMapper;

    @Override
    public List<SchoolPic> queryList(SchoolPic schoolPic) {
        LambdaQueryWrapper<SchoolPic> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolPic.getPicName()), SchoolPic::getPicName, schoolPic.getPicName())
                .eq(isNotBlank(schoolPic.getIsShow()), SchoolPic::getIsShow, schoolPic.getIsShow())
                .orderByAsc(SchoolPic::getSeqencing)
                .orderByDesc(SchoolPic::getCreateTime)
        ;
        return schoolPicMapper.selectList(lqw);
    }

}
