package yangtz.cs.liu.campus.service.impl.interest;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesAttendance;
import yangtz.cs.liu.campus.mapper.interest.SchoolInterestClassesAttendanceMapper;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesAttendanceService;
import yangtz.cs.liu.campus.vo.interest.AttendanceVO;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

/**
 * 兴趣班考勤信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2022-10-09
 */
@Service
public class SchoolInterestClassesAttendanceServiceImpl extends ServiceImpl<SchoolInterestClassesAttendanceMapper, SchoolInterestClassesAttendance> implements ISchoolInterestClassesAttendanceService
{
    @Autowired
    private SchoolInterestClassesAttendanceMapper schoolInterestClassesAttendanceMapper;
    /**
     * 查询兴趣班考勤信息列表
     * 
     * @param schoolInterestClassesAttendance 兴趣班考勤信息
     * @return 兴趣班考勤信息
     */
    @Override
    public List<AttendanceVO> queryList(SchoolInterestClassesAttendance schoolInterestClassesAttendance, Long interestClassesId)
    {
        schoolInterestClassesAttendance.setInterestClassesId(interestClassesId);
        return schoolInterestClassesAttendanceMapper.queryList(schoolInterestClassesAttendance);
    }

    //获取详情
    @Override
    public AttendanceVO getInfo(Long id) {
        return schoolInterestClassesAttendanceMapper.getInfo(id);
    }
}
