package yangtz.cs.liu.campus.service.impl.exam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.annotation.DeptFilter;
import com.core.utils.LogfieldUtil;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.exam.ExamUser;
import yangtz.cs.liu.campus.mapper.exam.ExamUserMapper;
import yangtz.cs.liu.campus.service.exam.IExamUserService;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;


import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;


@Service
public class ExamUserServiceImpl extends ServiceImpl<ExamUserMapper, ExamUser> implements IExamUserService {

    @Autowired
    private ExamUserMapper examUserMapper;

    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查询活动范围列表（通过exam_id联系）
     *
     * @param examUser
     * @return
     */
    @Override
    public List<ExamUserVo> queryList(ExamUserVo examUser) {
        return examUserMapper.select(examUser);
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @Override
    public List<ExamUserVo> export(List<Integer> ids) {
        List<ExamUserVo> list = new ArrayList<>();
        for (Integer id : ids) {
            //查询列表
            ExamUserVo examUserVo = examUserMapper.exportById(id);
            list.add(examUserVo);
        }
        return list;
    }

    @Override
    public List<Long> selectAllUserIdByExamId(Long examId) {
        return examUserMapper.selectAllUserIdByExamId(examId);
    }

    @Override
    @DeptFilter(deptAlias = "d")
    public List<ExamUserVo> selectAddList(ExamUserVo examUser, List<Long> userIdList) {
        return examUserMapper.selectAddList(userIdList, examUser);
    }

    @Override
    public int addExamUsers(Long examId, Long[] userIds) {
        //检查是否该范围下已经有这个学员了
        List<Long> userIdList = examUserMapper.selectAllUserIdByExamId(examId);
        List<ExamUser> examUserList = new ArrayList<>();

        for (Long userId : userIds) {
            if (userIdList.contains(userId)) {
                throw new ServiceException("问卷范围内已经有该学员");
            }
            //通过用户id去查询dept_id,dept_name,user_name
            SysUser user = sysUserMapper.selectUserById(userId);
            try {
                ExamUser examUser = new ExamUser();
                examUser.setExamId(examId);
                examUser.setUserId(userId);
                examUser.setDeptId(user.getDeptId());
                examUser.setDeptName(user.getDept().getDeptName());
                examUser.setUserName(user.getUserName());
                examUser.setIsJoin("0");
                examUser.insert();
                examUserList.add(examUser);
            }catch (Exception e){
                throw new ServiceException("有用户信息不完整，无法添加");
            }

        }
        return examUserMapper.insertExamUsers(examUserList);
    }
}
