package yangtz.cs.liu.campus.service.impl.curricula;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.curricula.CurriculaStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentScore;
import yangtz.cs.liu.campus.mapper.curricula.CurriculaStudentMapper;
import yangtz.cs.liu.campus.mapper.curricula.StudentScoreMapper;
import yangtz.cs.liu.campus.service.curricula.ICurriculaStudentService;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentVo;

import java.util.List;

@Service
public class CurriculaStudentServiceImpl extends ServiceImpl<CurriculaStudentMapper, CurriculaStudent> implements ICurriculaStudentService {

    @Autowired
    private CurriculaStudentMapper curriculaStudentMapper;
    @Autowired
    private StudentScoreMapper studentScoreMapper;

    /**
     * 查看选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    @Override
    public List<CurriculaStudentVo> selectCurriculaStudentList(CurriculaStudentVo curriculaStudentVo) {
        return curriculaStudentMapper.selectCurriculaStudentList(curriculaStudentVo);
    }

    /**
     * 查看春季选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    @Override
    public List<CurriculaStudentVo> selectCurriculaStudentListCj(CurriculaStudentVo curriculaStudentVo) {
        return curriculaStudentMapper.selectCurriculaStudentListCj(curriculaStudentVo);
    }

    /**
     * 查看夏季选课情况列表(一次、二次、三次)
     * @param curriculaStudentVo
     * @return
     */
    @Override
    public List<CurriculaStudentVo> selectCurriculaStudentListXj(CurriculaStudentVo curriculaStudentVo) {
        List<CurriculaStudentVo> curriculaStudentVoList = curriculaStudentMapper.selectCurriculaStudentListXj(curriculaStudentVo);
        curriculaStudentVoList.forEach(curriculaStudentVo1 -> {
            //查询学生成绩
            LambdaQueryWrapper<SchoolStudentScore> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolStudentScore::getStudentId,curriculaStudentVo1.getStudentId())
                    .in(SchoolStudentScore::getExamType,1,2,3)
                    .orderByDesc(SchoolStudentScore::getExamType).last("LIMIT 1");
            SchoolStudentScore schoolStudentScore = studentScoreMapper.selectOne(wrapper);
            if (StringUtils.isNotNull(schoolStudentScore)){
                //物理+政治+化学
                if (curriculaStudentVo1.getSelectedCourse().equals("1")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getChemistry();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+政治+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("2")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+政治+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("3")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+政治+历史
                if (curriculaStudentVo1.getSelectedCourse().equals("4")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getHistory();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+历史+化学
                if (curriculaStudentVo1.getSelectedCourse().equals("5")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getHistory() + schoolStudentScore.getChemistry();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+历史+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("6")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getHistory() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+地理+化学
                if (curriculaStudentVo1.getSelectedCourse().equals("7")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getGeography() + schoolStudentScore.getChemistry();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+地理+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("8")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getGeography() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+化学+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("9")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getChemistry() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("10")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+政治+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("11")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getPolitics() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+政治+历史
                if (curriculaStudentVo1.getSelectedCourse().equals("12")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getPolitics() + schoolStudentScore.getHistory();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+政治+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("13")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getPolitics() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("14")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+历史+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("15")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getHistory() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+地理+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("16")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getGeography() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //生物+政治+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("17")){
                    double courseScore = schoolStudentScore.getBiology() + schoolStudentScore.getPolitics() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //生物+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("18")){
                    double courseScore = schoolStudentScore.getBiology() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //生物+政治+历史
                if (curriculaStudentVo1.getSelectedCourse().equals("19")){
                    double courseScore = schoolStudentScore.getBiology() + schoolStudentScore.getPolitics() + schoolStudentScore.getHistory();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //政治+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("20")){
                    double courseScore = schoolStudentScore.getPolitics() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
            }
        });
        return curriculaStudentVoList;
    }

    /**
     * 查看艺体选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    @Override
    public List<CurriculaStudentVo> selectCurriculaStudentListYt(CurriculaStudentVo curriculaStudentVo) {
        List<CurriculaStudentVo> curriculaStudentVoList = curriculaStudentMapper.selectCurriculaStudentListYt(curriculaStudentVo);
        return curriculaStudentVoList;
    }

    /**
     * 查看夏季选课情况(期末)
     * @param curriculaStudentVo
     * @return
     */
    @Override
    public List<CurriculaStudentVo> selectCurriculaStudentListXjQm(CurriculaStudentVo curriculaStudentVo) {
        List<CurriculaStudentVo> curriculaStudentVoList = curriculaStudentMapper.selectCurriculaStudentListXjEc(curriculaStudentVo);
        curriculaStudentVoList.forEach(curriculaStudentVo1 -> {
            //查询学生成绩
            LambdaQueryWrapper<SchoolStudentScore> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolStudentScore::getStudentId,curriculaStudentVo1.getStudentId())
                    .eq(SchoolStudentScore::getExamType,"4");
            SchoolStudentScore schoolStudentScore = studentScoreMapper.selectOne(wrapper);
            if (StringUtils.isNotNull(schoolStudentScore)){
                //物理+政治+化学
                if (curriculaStudentVo1.getSelectedCourse().equals("1")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getChemistry();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+政治+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("2")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+政治+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("3")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+政治+历史
                if (curriculaStudentVo1.getSelectedCourse().equals("4")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getPolitics() + schoolStudentScore.getHistory();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+历史+化学
                if (curriculaStudentVo1.getSelectedCourse().equals("5")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getHistory() + schoolStudentScore.getChemistry();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+历史+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("6")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getHistory() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+地理+化学
                if (curriculaStudentVo1.getSelectedCourse().equals("7")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getGeography() + schoolStudentScore.getChemistry();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+地理+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("8")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getGeography() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+化学+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("9")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getChemistry() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //物理+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("10")){
                    double courseScore = schoolStudentScore.getPhysics() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+政治+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("11")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getPolitics() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+政治+历史
                if (curriculaStudentVo1.getSelectedCourse().equals("12")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getPolitics() + schoolStudentScore.getHistory();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+政治+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("13")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getPolitics() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("14")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+历史+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("15")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getHistory() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //化学+地理+生物
                if (curriculaStudentVo1.getSelectedCourse().equals("16")){
                    double courseScore = schoolStudentScore.getChemistry() + schoolStudentScore.getGeography() + schoolStudentScore.getBiology();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //生物+政治+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("17")){
                    double courseScore = schoolStudentScore.getBiology() + schoolStudentScore.getPolitics() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //生物+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("18")){
                    double courseScore = schoolStudentScore.getBiology() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //生物+政治+历史
                if (curriculaStudentVo1.getSelectedCourse().equals("19")){
                    double courseScore = schoolStudentScore.getBiology() + schoolStudentScore.getPolitics() + schoolStudentScore.getHistory();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
                //政治+历史+地理
                if (curriculaStudentVo1.getSelectedCourse().equals("20")){
                    double courseScore = schoolStudentScore.getPolitics() + schoolStudentScore.getHistory() + schoolStudentScore.getGeography();
                    curriculaStudentVo1.setCourseScore(courseScore);
                }
            }
        });
        return curriculaStudentVoList;
    }

    /**
     * 查看选课情况列表(班主任)
     * @param curriculaStudentVo
     * @return
     */
    @Override
    public List<CurriculaStudentVo> selectCurriculaStudentListBzr(CurriculaStudentVo curriculaStudentVo) {
        curriculaStudentVo.setTeacherId(SecurityUtils.getLoginUser().getUser().getUserId());
        return curriculaStudentMapper.selectCurriculaStudentListBzr(curriculaStudentVo);
    }
}
