package yangtz.cs.liu.campus.service.impl.conference;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.domain.server.Sys;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.conference.SchoolConference;
import yangtz.cs.liu.campus.domain.conference.SchoolConferenceDetails;
import yangtz.cs.liu.campus.mapper.conference.SchoolConferenceDetailsMapper;
import yangtz.cs.liu.campus.service.conference.ISchoolConferenceDetailsService;
import yangtz.cs.liu.campus.vo.conference.ConferenceDetailsVO;
import yangtz.cs.liu.campus.vo.message.PushParentVO;

import java.util.ArrayList;
import java.util.List;

import static com.ruoyi.common.utils.StringUtils.isNotNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

@Service
public class SchoolConferenceDetailsServiceImpl extends ServiceImpl<SchoolConferenceDetailsMapper, SchoolConferenceDetails> implements ISchoolConferenceDetailsService {
    @Autowired
    SchoolConferenceDetailsMapper schoolConferenceDetailsMapper;

    public static final String NOPRESENCE = "0";
    public static final String PRESENCE = "1";


    @Override
    @DataScope(deptAlias = "d")
    //此处会启动切面编程检查参数joinPoint
    public List<ConferenceDetailsVO> getAllUsers(Long conferenceId, SysUser user)
    {
        //已选择的用户id
        List<Long> userIdList = schoolConferenceDetailsMapper.selectUserIds(conferenceId);
        return schoolConferenceDetailsMapper.getAllUsers(userIdList,user);
    }

    @Override
    public List<ConferenceDetailsVO> queryList(ConferenceDetailsVO detailsVO) {
        return schoolConferenceDetailsMapper.getAllJoiner(detailsVO);
    }

    @Override
    public int addUsers(Long conferenceId, List<Long> ids) {
        List<SchoolConferenceDetails> list = new ArrayList<>();
        for(Long userId : ids){
            SchoolConferenceDetails details = new SchoolConferenceDetails();
            details.setConferenceId(conferenceId);
            details.setUserId(userId);
            details.setState(NOPRESENCE);
            details.insert();
            list.add(details);
        }
        return schoolConferenceDetailsMapper.insertUsers(list);
    }
}
