package yangtz.cs.liu.campus.service.impl.award;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.mapper.accessory.AccessoryMapper;
import yangtz.cs.liu.campus.mapper.award.AwardMapper;
import yangtz.cs.liu.campus.domain.award.Award;
import yangtz.cs.liu.campus.service.award.IAwardService;

/**
 * 获奖情况Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@Service
public class AwardServiceImpl implements IAwardService
{
    @Autowired
    private AwardMapper awardMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;

    /**
     * 查询获奖情况
     *
     * @param id 获奖情况主键
     * @return 获奖情况
     */
    @Override
    public Award selectAwardById(Long id)
    {
        Award award = awardMapper.selectAwardById(id);
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getBusinessId,award.getId())
                .eq(SchoolAccessory::getAccessoryType,"获奖情况附件");
        List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
        if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
            award.setSchoolAccessoryList(accessories);
        }
        return award;
    }

    /**
     * 查询获奖情况列表
     *
     * @param award 获奖情况
     * @return 获奖情况
     */
    @Override
    public List<Award> selectAwardList(Award award)
    {
        award.setTeacherId(SecurityUtils.getLoginUser().getUser().getUserId());
        List<Award> list = awardMapper.selectAwardList(award);
        list.forEach(award1 -> {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,award1.getId())
                    .eq(SchoolAccessory::getAccessoryType,"获奖情况附件");
            List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
            if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
                award1.setSchoolAccessoryList(accessories);
            }
        });
        return list;
    }

    /**
     * 新增获奖情况
     *
     * @param award 获奖情况
     * @return 结果
     */
    @Transactional
    @Override
    public int insertAward(Award award)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        award.setTeacherId(user.getUserId());
        award.setTeacherName(user.getUserName());
        award.setCreateBy(user.getUserName());
        award.setCreateTime(DateUtils.getNowDate());
        int rows = awardMapper.insertAward(award);
        insertSchoolAccessory(award);
        return rows;
    }

    /**
     * 修改获奖情况
     *
     * @param award 获奖情况
     * @return 结果
     */
    @Transactional
    @Override
    public int updateAward(Award award)
    {
        award.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        award.setUpdateTime(DateUtils.getNowDate());
        awardMapper.deleteSchoolAccessoryByBusinessId(award.getId());
        insertSchoolAccessory(award);
        return awardMapper.updateAward(award);
    }

    /**
     * 批量删除获奖情况
     *
     * @param ids 需要删除的获奖情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteAwardByIds(Long[] ids)
    {
        awardMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return awardMapper.deleteAwardByIds(ids);
    }

    /**
     * 删除获奖情况信息
     *
     * @param id 获奖情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteAwardById(Long id)
    {
        awardMapper.deleteSchoolAccessoryByBusinessId(id);
        return awardMapper.deleteAwardById(id);
    }

    /**
     * 新增附件信息信息
     *
     * @param award 获奖情况对象
     */
    public void insertSchoolAccessory(Award award)
    {
        List<SchoolAccessory> schoolAccessoryList = award.getSchoolAccessoryList();
        Long id = award.getId();
        if (StringUtils.isNotNull(schoolAccessoryList))
        {
            List<SchoolAccessory> list = new ArrayList<SchoolAccessory>();
            for (SchoolAccessory schoolAccessory : schoolAccessoryList)
            {
                schoolAccessory.setModuleName("个人工作-获奖情况");
                schoolAccessory.setAccessoryType("获奖情况附件");
                schoolAccessory.setBusinessId(id);
                list.add(schoolAccessory);
            }
            if (list.size() > 0)
            {
                awardMapper.batchSchoolAccessory(list);
            }
        }
    }
}
