package yangtz.cs.liu.campus.service.exam;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.exam.ExamMain;
import yangtz.cs.liu.campus.vo.exam.ExamMainVo;
import yangtz.cs.liu.campus.vo.exam.ScoreVo;

import java.util.List;

/**
 * 问卷调查Service层
 */
public interface IExamMainService extends IService<ExamMain> {

    /**
     * 查询问卷调查列表
     *
     * @param examMain
     * @return
     */
    List<ExamMain> queryList(ExamMain examMain);

    /**
     * 查询参与情况
     *
     * @param exam
     * @return
     */
    List<ExamMainVo> selectTakeExamPeoNumList(ExamMainVo exam);

    /**
     * 查询代办任务
     *
     * @param examMainVo
     * @return
     */
    List<ExamMainVo> selectExamTasks(ExamMainVo examMainVo);

    /**
     * 删除问卷调查表
     *
     * @param ids
     * @return
     */
    int deleteByIds(List<Integer> ids);

    /**
     * 参加打分功能
     *
     * @param examId
     * @param score
     */
    void join(Long examId, ScoreVo score);

    /**
     * 检查是否可以发布
     * @param id
     */
    void checkExam(Long id);

    /**
     * 更改问卷状态
     * @param examState
     * @param id
     * @return
     */
    int editExamState(Character examState, Long id);

    /**
     *根据用户id获取问卷活动
     */
    List<ExamMainVo>  getExam(Long userId,ExamMainVo examMainVo);
}
