package yangtz.cs.liu.campus.service.curricula;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.curricula.CurriculaStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentScore;
import yangtz.cs.liu.campus.vo.student.SchoolStudentScoreVo;

import java.util.List;

public interface IStudentScoreService extends IService<SchoolStudentScore> {

    /**
     * 查询学生成绩列表
     * @param schoolStudentScoreVo
     * @return
     */
    List<SchoolStudentScoreVo> selectStudentScoreList(SchoolStudentScoreVo schoolStudentScoreVo);

    //根据学生ID查询成绩
    List<SchoolStudentScoreVo> selectStudentScoreList(Long studentId);

    /**
     * 查询学生成绩详细信息
     * @param id
     * @return
     */
    SchoolStudentScoreVo selectStudentScoreById(Long id);

    /**
     * 导入
     * @param list
     * @return
     */
    String importExamDetail(List<SchoolStudentScoreVo> list,Long curriculaId);

    /**
     * 校验
     * @param list
     */
    void checkImport(List<SchoolStudentScoreVo> list);

    /**
     * 根据学号获取学生信息
     * @param schoolNo
     * @return
     */
    SchoolStudentScoreVo selectStudent(String schoolNo);

    /**
     * 新增学生成绩
     * @param schoolStudentScore
     * @return
     */
    int insertStudentScore(SchoolStudentScore schoolStudentScore);

    /**
     * 修改学生成绩信息
     * @param schoolStudentScore
     * @return
     */
    int updateStudentScore(SchoolStudentScore schoolStudentScore);

    /**
     * 批量删除学生成绩信息
     * @param ids
     * @return
     */
    int deleteStudentScore(Long[] ids);

    /**
     * 根据类型查询三类成绩
     */
    List<SchoolStudentScoreVo> getStudentTypeViwe(CurriculaStudent curriculaStudent);
}
