package yangtz.cs.liu.campus.service.curricula;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.SysDictType;
import yangtz.cs.liu.campus.domain.curricula.CurriculaVariable;
import yangtz.cs.liu.campus.vo.curricula.CurriculaVariableVo;

import java.util.List;
import java.util.Map;

public interface ICurriculaVariableService extends IService<CurriculaVariable> {
    /**
     * 查询选课任务列表
     * @param curriculaVariable
     * @return
     */
    List<CurriculaVariableVo> selectCurriculaVariableList(CurriculaVariableVo curriculaVariable);

    /**
     * 新增选课任务
     * @param curriculaVariableVo
     * @return
     */
    int insertCurriculaVariable(CurriculaVariableVo curriculaVariableVo);

    /**
     * 获取选课任务详细信息
     * @param id
     * @return
     */
    CurriculaVariableVo selectCurriculaVariableById(Long id);

    /**
     * 获取当前最新级部
     * @return
     */
    Map<String,String> getNewGrade();

    /**
     * 获取班级下拉框
     * @param grade
     * @return
     */
    List<Map<String,String>> selectClass(String grade);

    /**
     * 修改选课任务
     * @param curriculaVariableVo
     * @return
     */
    int updateCurriculaVariable(CurriculaVariableVo curriculaVariableVo);

    /**
     * 获取选课任务下拉框
     * @return
     */
    List<Map<String,String>> getGrade();

    /**
     * 获取春季，夏季，艺体科目
     * @return
     */
    List<SysDictType> selectXkTypeList();

}
