package yangtz.cs.liu.campus.mapper.training;

import java.util.List;
import yangtz.cs.liu.campus.domain.training.Training;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 培训情况Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface TrainingMapper
{
    /**
     * 查询培训情况
     *
     * @param id 培训情况主键
     * @return 培训情况
     */
    public Training selectTrainingById(Long id);

    /**
     * 查询培训情况列表
     *
     * @param training 培训情况
     * @return 培训情况集合
     */
    public List<Training> selectTrainingList(Training training);

    /**
     * 新增培训情况
     *
     * @param training 培训情况
     * @return 结果
     */
    public int insertTraining(Training training);

    /**
     * 修改培训情况
     *
     * @param training 培训情况
     * @return 结果
     */
    public int updateTraining(Training training);

    /**
     * 删除培训情况
     *
     * @param id 培训情况主键
     * @return 结果
     */
    public int deleteTrainingById(Long id);

    /**
     * 批量删除培训情况
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTrainingByIds(Long[] ids);

    /**
     * 批量删除附件信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 批量新增附件信息
     *
     * @param schoolAccessoryList 附件信息列表
     * @return 结果
     */
    public int batchSchoolAccessory(List<SchoolAccessory> schoolAccessoryList);


    /**
     * 通过培训情况主键删除附件信息信息
     *
     * @param id 培训情况ID
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessId(Long id);
}
