package yangtz.cs.liu.campus.mapper.time;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.time.SchoolSchedule;
import yangtz.cs.liu.campus.domain.time.SchoolTimeTable;
import yangtz.cs.liu.campus.vo.time.SchoolCourseTableVO;
import yangtz.cs.liu.wechat.vo.schoolTime.SchoolTimeTableVo;

import java.util.List;

@Mapper
public interface SchoolTimeTableMapper extends BaseMapper<SchoolTimeTable> {

    /**
     * 查询课程列表
     *
     * @param schoolTimeTable 课程
     * @return 课程集合
     */
    List<SchoolCourseTableVO> selectSchoolTimeTableList(SchoolTimeTable schoolTimeTable);

    /**
     * 导出 课程表
     *
     */
    List<SchoolSchedule> selectSchoolSchedule(SchoolTimeTable schoolTimeTable);

    /**
     * 微信公众号获取课表
     * @param schoolTimeTableVo
     * @return
     */
    List<SchoolTimeTableVo> getSchoolSchedule(SchoolTimeTableVo schoolTimeTableVo);

    List<SchoolTimeTableVo> getTimeTable(Long teacherId);

    /**查询班级该学期某节次某教师的课*/
    List<SchoolTimeTable> getTeacherTable(@Param("classId") Long classId,
                                          @Param("termId") int termId,
                                          @Param("courseId") Long courseId,
                                          @Param("sortId") int sortId,
                                          @Param("teacherId") Long teacherId);
}
