package yangtz.cs.liu.campus.mapper.teacherFiles;

import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesThesis;
import yangtz.cs.liu.campus.domain.thesis.Thesis;

import java.util.List;
import java.util.Map;

/**
 * 教师档案论文情况Mapper接口
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public interface TeacherFilesThesisMapper 
{
    /**
     * 查询教师档案论文情况
     * 
     * @param id 教师档案论文情况主键
     * @return 教师档案论文情况
     */
    public TeacherFilesThesis selectTeacherFilesThesisById(Long id);

    /**
     * 查询教师档案论文情况列表
     * 
     * @param teacherFilesThesis 教师档案论文情况
     * @return 教师档案论文情况集合
     */
    public List<TeacherFilesThesis> selectTeacherFilesThesisList(TeacherFilesThesis teacherFilesThesis);

    public List<TeacherFilesThesis> selectTeacherFilesThesisListByFilesId(Long filesId);

    /**
     * 新增教师档案论文情况
     * 
     * @param teacherFilesThesis 教师档案论文情况
     * @return 结果
     */
    public int insertTeacherFilesThesis(TeacherFilesThesis teacherFilesThesis);

    /**
     * 修改教师档案论文情况
     * 
     * @param teacherFilesThesis 教师档案论文情况
     * @return 结果
     */
    public int updateTeacherFilesThesis(TeacherFilesThesis teacherFilesThesis);

    /**
     * 删除教师档案论文情况
     * 
     * @param id 教师档案论文情况主键
     * @return 结果
     */
    public int deleteTeacherFilesThesisById(Long id);

    public int deleteTeacherFilesThesisByFilesId(Long filesId);

    /**
     * 批量删除教师档案论文情况
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTeacherFilesThesisByIds(Long[] ids);

    public List<Thesis> selectThesisList(Map map);
}
