package yangtz.cs.liu.campus.mapper.teacherFiles;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schooloffical.SchoolOfficial;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFiles;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesVO;

import java.util.List;
import java.util.Map;

/**
 * 教师档案Mapper接口
 *
 * @author ruoyi
 * @date 2023-09-06
 */
public interface TeacherFilesMapper extends BaseMapper<TeacherFiles>
{
    /**
     * 查询教师档案
     *
     * @param id 教师档案主键
     * @return 教师档案
     */
    public TeacherFilesVO selectTeacherFilesById(Long id);

    /**
     * 查询教师档案列表
     *
     * @param teacherFiles 教师档案
     * @return 教师档案集合
     */
    public List<TeacherFiles> selectTeacherFilesList(TeacherFiles teacherFiles);

    /**
     * 统计已发布
     *
     * @param teacherFiles 教师档案
     * @return 教师档案集合
     */
    public int countYfb(TeacherFiles teacherFiles);

    /**
     * 统计已确认
     *
     * @param teacherFiles 教师档案
     * @return 教师档案集合
     */
    public int countYqr(TeacherFiles teacherFiles);

    /**
     * 新增教师档案
     *
     * @param teacherFiles 教师档案
     * @return 结果
     */
    public int insertTeacherFiles(TeacherFiles teacherFiles);

    /**
     * 修改教师档案
     *
     * @param teacherFiles 教师档案
     * @return 结果
     */
    public int updateTeacherFiles(TeacherFiles teacherFiles);

    public int updateTeacherFilesState(String noticeId);


    public int updateTeacherFilesState1(String noticeId);

    public int updateTeacherFilesState7(String noticeId);

    public int updateTeacherFilesName(Map map);

    /**
     * 删除教师档案
     *
     * @param id 教师档案主键
     * @return 结果
     */
    public int deleteTeacherFilesById(Long id);

    /**
     * 批量删除教师档案
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTeacherFilesByIds(Long[] ids);

    public int deleteTeacherFilesByNoticeId(String noticeId);

    public List<Long> getGradeId(Long teacherId);

}
