package yangtz.cs.liu.campus.mapper.teacherFiles;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFiles;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesDeletRecord;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesVO;

import java.util.List;
import java.util.Map;

/**
 * 教师档案删除记录mapper
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
@Mapper
public interface TeacherFilesDeletRecordMapper
{


    /**
     * 添加记录
     */
    @Insert("insert into teacher_file_delet_record (user_id,tel,gruo_name,user_name,t_id,g_id) VALUES (#{userId},#{tel},#{gruoName},#{userName},#{tId},#{gId})  ")
    public Integer addTeacherFilesDeletRecord(TeacherFilesDeletRecord teacherFilesDeletRecord);

    /**
     * 删除记录
     */

    @Delete("delete  from teacher_file_delet_record where id =#{id} ")
    public Integer deletRecord(Long id);

    /**
     * 查询老师
     * @param tId
     * @return
     */
    @Select("select  * from teacher_file_delet_record where t_id =#{tId} ")
    public List<TeacherFilesDeletRecord> getTeacherRocer(String tId);

    @Select("select  * from teacher_file_delet_record where id =#{id} ")
    public TeacherFilesDeletRecord getByid(Long id);
}
