package yangtz.cs.liu.campus.mapper.teacher;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import org.apache.ibatis.annotations.Mapper;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherNameListVo;

import java.util.List;

/*
* 学校老师信息接口
* */
@Mapper
public interface SchoolTeacherMapper extends BaseMapper<SchoolTeacher>{

    //老师信息列表
    List<SchoolTeacher> selectSchoolTeacherList(SchoolTeacherVO schoolTeacher);

    //老师信息列表（不过滤）
    List<SchoolTeacher> teacherList(SchoolTeacherVO schoolTeacher);


    int insertTeacher(SchoolTeacher schoolTeacher);

    List<SchoolTeacher> listByIds(List<Long> idList);

    SchoolTeacher selectSchoolTeacherById(Long id);

    int updateSchoolTeacher(SchoolTeacher schoolTeacher);

    SchoolTeacher judgeSchoolTeacher(SchoolTeacherVO schoolTeacher);

    int deleteSchoolTeacherByIds(List<Long> ids);

    List<TeacherNameListVo> selectSchoolTeacherNameList();

//    int deleteSchoolTeacherById(Long id);
    List<SchoolTeacher> query(SchoolTeacher schoolTeacher);


    /**
     * 微信公众号教师登录的查询
     * @param teacherIdCard
     * @return
     */
    SchoolTeacher selectTeacher(String teacherIdCard);

    SchoolTeacher selectTeacherByDdUerId(String dduserId);

    /**
     * 微信公众号(通过姓名查询)
     * @param teacherName
     * @return
     */
    SchoolTeacher selectUserByTeacherName(String teacherName);

    /**
     * 公众号获取老师信息
     *
     * @param studentId
     * @return
     */
    List<SchoolTeacher> getTeacherInfo(Long studentId);

    int insertSchoolTeacher(SchoolTeacherVO schoolTeacherVO);

    int updateTeacher(SchoolTeacherVO schoolTeacherVO);

    //根据userID获取老师id
    List<Long> getIdByUserId(@Param("userIdList") List<Long> userIdList);

    /**个人工作->基本信息*/
    SchoolTeacher getProfile(Long userId);

    //查询全部教职工
    List<SchoolTeacher> getAllTeachers(SchoolTeacher teacher);

    /**
     * 获取所在处室处室主任
     */
    List<SchoolTeacher> getSectionLeader(@Param("deptId") Long deptId,
                                         @Param("role") String role,
                                        @Param("entity") SchoolTeacherVO entity);

    /**
     * (改造)获取所在处室处室主任
     */
    List<SchoolTeacher> getSectionDirector(@Param("deptId") Long deptId,
                                         @Param("role") String role,
                                         @Param("entity") SchoolTeacherVO entity);

    //根据设备号部门姓名，查询当前系统是否有该教职工
    SchoolTeacherVO judge(String deviceNum);

    //查询级部下所有教师
    List<SchoolTeacherVO> getTeacherByGradeId(Long gradeId);

    //查询本科室所有职工
    List<SchoolTeacherVO> getTeacherByDeptId(@Param("deptId") Long deptId,
                                             @Param("type") String type);

    public int updatePic(@Param("userId") Long userId, @Param("avatar") String avatar);

    //通过手机号获取教师信息
    public SchoolTeacher getTeacherByPhone(String teacherTel);

    /**
     *
     * 根据userId 查询 openId
     */
    String getOpenIdByUserId(Long userId);

    /**
     *
     * 根据userId 查询 ddUserId
     */
    String getDdUserIdByUserId(Long userId);

    /**
     *
     * 根据userId 查询 unionId
     */
    String getUnionIdByUserId(Long userId);

    /**
     * 获取打卡教师列表
     */
    List<SchoolTeacher> selectClockTeacher();
}
