package yangtz.cs.liu.campus.mapper.studentChange;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.studentChange.StudentInfoChange;

import java.util.List;

/**
 * 学生关键信息变更Mapper接口
 * 
 * @author wengxiulin
 * @date 2023-02-20
 */
public interface StudentInfoChangeMapper extends BaseMapper<StudentInfoChange>
{
    /**
     * 查询学生关键信息变更
     * 
     * @param id 学生关键信息变更主键
     * @return 学生关键信息变更
     */
    public StudentInfoChange selectStudentInfoChangeById(Long id);

    /**
     * 查询学生关键信息变更列表
     * 
     * @param studentInfoChange 学生关键信息变更
     * @return 学生关键信息变更集合
     */
    public List<StudentInfoChange> selectStudentInfoChangeList(StudentInfoChange studentInfoChange);

    /**
     * 新增学生关键信息变更
     * 
     * @param studentInfoChange 学生关键信息变更
     * @return 结果
     */
    public int insertStudentInfoChange(StudentInfoChange studentInfoChange);

    /**
     * 修改学生关键信息变更
     * 
     * @param studentInfoChange 学生关键信息变更
     * @return 结果
     */
    public int updateStudentInfoChange(StudentInfoChange studentInfoChange);

    /**
     * 删除学生关键信息变更
     * 
     * @param id 学生关键信息变更主键
     * @return 结果
     */
    public int deleteStudentInfoChangeById(Long id);

    /**
     * 批量删除学生关键信息变更
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteStudentInfoChangeByIds(Long[] ids);
}
