package yangtz.cs.liu.campus.mapper.student;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentParent;
import yangtz.cs.liu.campus.vo.student.SchoolStudentParentVO;
import yangtz.cs.liu.wechat.vo.userInfo.UserInfoVo;


import java.util.List;
import java.util.Map;

@Mapper
public interface SchoolStudentParentMapper extends BaseMapper<SchoolStudentParent> {

    List<SchoolStudentParent> queryList(SchoolStudentParent schoolStudentParent);


    List<Map<String,Object>>  getRoleTypeByPhoneNumber(String phonenumber);

    /**
     * 微信公众号登录查询(电话)
     * @param parentTelephone
     * @return
     */
    SchoolStudentParent selectUserByParentTel(@Param("parentTelephone") String parentTelephone);

    /**
     * 公众号，获取用户信息
     *
     * @param studentId
     * @return
     */
    List<UserInfoVo> getUserInfo(Long studentId);

    /**
     * 公众号添加监护人
     * @param schoolStudentParent
     * @return
     */
    SchoolStudentParent selectByPhone(@Param("entity") SchoolStudentParent schoolStudentParent);

    /**
     * 公众号切换子女准备
     * @param phone
     */
    List<SchoolStudent> selectByParentId(String phone);

    List<SchoolStudentParent> selectByTelePhone(String parentPhone);

    Long getGradeIdByUserId(Long userId);

    /**
     * 查询所有家长信息
     * */
    List<SchoolStudentParentVO> getAllParent(SchoolStudentParentVO schoolStudentParentVO);

    //查询父母信息 班主任工作
    List<SchoolStudentParentVO> selectParentList(@Param("schoolStudentParentVO")SchoolStudentParentVO schoolStudentParentVO,@Param("teacherId") Long teacherId);

    //查询父母信息 教师工作
    List<SchoolStudentParentVO> selectParentListByMentor(@Param("schoolStudentParentVO")SchoolStudentParentVO schoolStudentParentVO,@Param("teacherId") Long teacherId);

    //查询本级部下所有家长信息
    List<SchoolStudentParent> getParentByGradeId(Long gradeId);
    List<SchoolStudentParentVO> getParentVoByGradeId(Long gradeId);


    //教师工作,级部工作=家长信息
    List<SchoolStudentParentVO> selectTeacherParent(@Param("schoolStudentParentVO")SchoolStudentParentVO schoolStudentParentVO,
                                                    @Param("classIds") List<Long> classIds);

    /**
     * 根据id 查询 openId
     */
    String getOpenIdById(Long id);

    /**
     * 更新学生家长信息
     * @param updateParentList
     */
    void updateParentList(@Param("list") List<SchoolStudentParent> updateParentList);
//    新增学生家长信息
    void addParentList(@Param("list") List<SchoolStudentParent> addParentList);
}
