package yangtz.cs.liu.campus.mapper.schoolSecurity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVideoConsult;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVideoConsultVo;

import java.util.List;

/**
 * 监控录像调用(内部)Mapper接口
 *
 * @author ruoyi
 * @date 2023-09-11
 */
public interface SchoolVideoConsultMapper extends BaseMapper<SchoolVideoConsult>
{

    /**
     * 查询监控录像调用(内部)
     *
     * @param id 监控录像调用(内部)主键
     * @return 监控录像调用(内部)
     */
    public SchoolVideoConsultVo selectSchoolVideoConsultById(Long id);

    /**
     * 查询监控录像调用(内部)列表
     *
     * @param schoolVideoConsultVo 监控录像调用(内部)
     * @return 监控录像调用(内部)集合
     */
    public List<SchoolVideoConsultVo> selectSchoolVideoConsultList(SchoolVideoConsultVo schoolVideoConsultVo);

    /**
     * 新增监控录像调用(内部)
     *
     * @param schoolVideoConsultVo 监控录像调用(内部)
     * @return 结果
     */
    public int insertSchoolVideoConsult(SchoolVideoConsultVo schoolVideoConsultVo);

    /**
     * 修改监控录像调用(内部)
     *
     * @param schoolVideoConsultVo 监控录像调用(内部)
     * @return 结果
     */
    public int updateSchoolVideoConsult(SchoolVideoConsultVo schoolVideoConsultVo);

    /**
     * 删除监控录像调用(内部)
     *
     * @param id 监控录像调用(内部)主键
     * @return 结果
     */
    public int deleteSchoolVideoConsultById(Long id);

    /**
     * 批量删除监控录像调用(内部)
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolVideoConsultByIds(Long[] ids);
}
