package yangtz.cs.liu.campus.mapper.schoolSecurity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVideoConsultExternal;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVideoConsultExternalVo;

import java.util.List;

/**
 * 监控调阅（外部）Mapper接口
 *
 * @author ruoyi
 * @date 2023-09-11
 */
public interface SchoolVideoConsultExternalMapper extends BaseMapper<SchoolVideoConsultExternal>
{

    /**
     * 查询监控调阅（外部）
     *
     * @param id 监控调阅（外部）主键
     * @return 监控调阅（外部）
     */
    public SchoolVideoConsultExternalVo selectSchoolVideoConsultExternalById(Long id);

    /**
     * 查询监控调阅（外部）列表
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 监控调阅（外部）集合
     */
    public List<SchoolVideoConsultExternalVo> selectSchoolVideoConsultExternalList(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo);

    /**
     * 新增监控调阅（外部）
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 结果
     */
    public int insertSchoolVideoConsultExternal(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo);

    /**
     * 修改监控调阅（外部）
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 结果
     */
    public int updateSchoolVideoConsultExternal(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo);

    /**
     * 删除监控调阅（外部）
     *
     * @param id 监控调阅（外部）主键
     * @return 结果
     */
    public int deleteSchoolVideoConsultExternalById(Long id);

    /**
     * 批量删除监控调阅（外部）
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolVideoConsultExternalByIds(Long[] ids);

    /**
     * 批量删除附件信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 批量新增附件信息
     *
     * @param schoolAccessoryList 附件信息列表
     * @return 结果
     */
    public int batchSchoolAccessory(List<SchoolAccessory> schoolAccessoryList);


    /**
     * 通过监控调阅（外部）主键删除附件信息信息
     *
     * @param id 监控调阅（外部）ID
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessId(Long id);
}
