package yangtz.cs.liu.campus.mapper.schoolRewardsPunishments;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScAwards;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScAwardsVo;

import java.util.List;

/**
 * 学校获奖Mapper接口
 *
 * @author ruoyi
 * @date 2023-11-06
 */
public interface SchoolScAwardsMapper extends BaseMapper<SchoolScAwards>
{
    /**
     * 查询学校获奖
     *
     * @param id 学校获奖主键
     * @return 学校获奖
     */
    public SchoolScAwardsVo selectSchoolScAwardsById(Long id);

    /**
     * 查询学校获奖列表
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 学校获奖集合
     */
    public List<SchoolScAwardsVo> selectSchoolScAwardsList(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 查询学校获奖列表(查看已通过)
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 学校获奖集合
     */
    public List<SchoolScAwardsVo> selectSchoolScAwardsListTg(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 新增学校获奖
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 结果
     */
    public int insertSchoolScAwards(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 修改学校获奖
     *
     * @param schoolScAwardsVo 学校获奖
     * @return 结果
     */
    public int updateSchoolScAwards(SchoolScAwardsVo schoolScAwardsVo);

    /**
     * 删除学校获奖
     *
     * @param id 学校获奖主键
     * @return 结果
     */
    public int deleteSchoolScAwardsById(Long id);

    /**
     * 批量删除学校获奖
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolScAwardsByIds(Long[] ids);

    /**
     * 批量新增附件信息
     *
     * @param schoolAccessoryList 附件信息列表
     * @return 结果
     */
    public int batchSchoolAccessory(List<SchoolAccessory> schoolAccessoryList);

    /**
     * 批量删除附件信息
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 通过学校获奖主键删除附件信息信息
     *
     * @param id 学校获奖ID
     * @return 结果
     */
    public int deleteSchoolAccessoryByBusinessId(Long id);

    /**
     * 获取所有学校获奖附件
     * @return
     */
    public List<SchoolAccessory> selectAccessoryList();
}
