package yangtz.cs.liu.campus.mapper.schoolLab;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLab;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabVo;

import java.util.List;
import java.util.Map;

/**
 * 实验室Mapper接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface SchoolLabMapper extends BaseMapper<SchoolLab>
{

    /**
     * 查询实验室
     *
     * @param id 实验室主键
     * @return 实验室
     */
    public SchoolLabVo selectSchoolLabById(Long id);

    /**
     * 查询实验室列表
     *
     * @param schoolLabVo 实验室
     * @return 实验室集合
     */
    public List<SchoolLabVo> selectSchoolLabList(SchoolLabVo schoolLabVo);

    /**
     * 新增实验室
     *
     * @param schoolLab 实验室
     * @return 结果
     */
    public int insertSchoolLab(SchoolLab schoolLab);

    /**
     * 修改实验室
     *
     * @param schoolLab 实验室
     * @return 结果
     */
    public int updateSchoolLab(SchoolLab schoolLab);

    /**
     * 删除实验室
     *
     * @param id 实验室主键
     * @return 结果
     */
    public int deleteSchoolLabById(Long id);

    /**
     * 批量删除实验室
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolLabByIds(Long[] ids);

    /**
     * 查询所有实验室管理员
     * @return
     */
    public List<Map<String,String>> getLabAdminAll();

    /**
     * 查询指定实验室管理员
     * @return
     */
    public Map<String,String> getLabAdmin(@Param("roleKey") String roleKey,@Param("userId") Long userId);

    /**
     * 查询全部学科
     * @return
     */
    public List<Map<String, String>> getSubAll();

    /**
     * 查询指定学科
     * @param dictValue
     * @return
     */
    Map<String, String> getSub(@Param("dictValue") String dictValue);
}
