package yangtz.cs.liu.campus.mapper.schoolLab;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabCompetition;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabCompetitionVo;

import java.util.List;
import java.util.Map;

/**
 * 实验室竞赛Mapper接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface SchoolLabCompetitionMapper extends BaseMapper<SchoolLabCompetition>
{

    /**
     * 查询实验室竞赛
     *
     * @param id 实验室竞赛主键
     * @return 实验室竞赛
     */
    public SchoolLabCompetitionVo selectSchoolLabCompetitionById(Long id);

    /**
     * 查询实验室竞赛列表
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 实验室竞赛集合
     */
    public List<SchoolLabCompetitionVo> selectSchoolLabCompetitionList(SchoolLabCompetitionVo schoolLabCompetitionVo);

    /**
     * 新增实验室竞赛
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 结果
     */
    public int insertSchoolLabCompetition(SchoolLabCompetitionVo schoolLabCompetitionVo);

    /**
     * 修改实验室竞赛
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 结果
     */
    public int updateSchoolLabCompetition(SchoolLabCompetitionVo schoolLabCompetitionVo);

    /**
     * 删除实验室竞赛
     *
     * @param id 实验室竞赛主键
     * @return 结果
     */
    public int deleteSchoolLabCompetitionById(Long id);

    /**
     * 批量删除实验室竞赛
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolLabCompetitionByIds(Long[] ids);

    /**
     * 新增证书照片
     * @param list
     * @return
     */
    int batchSchoolAccessory(List<SchoolAccessory> list);

    /**
     * 批量删除证书照片
     * @param ids
     * @return
     */
    int deleteSchoolAccessoryByBusinessIds(Long[] ids);

    /**
     * 删除证书照片
     * @param id
     * @return
     */
    int deleteSchoolAccessoryByBusinessId(Long id);

    /**
     * 获取教师
     * @param sysUser
     * @return
     */
    List<Map<String, Object>> getTeacher(SysUser sysUser);
}
