package yangtz.cs.liu.campus.mapper.schoolLab;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolExperimentPlan;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolExperimentPlanClass;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolExperimentPlanVo;

import java.util.List;
import java.util.Map;

/**
 * 实验计划Mapper接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface SchoolExperimentPlanMapper extends BaseMapper<SchoolExperimentPlan>
{

    /**
     * 查询实验计划
     *
     * @param id 实验计划主键
     * @return 实验计划
     */
    public SchoolExperimentPlanVo selectSchoolExperimentPlanById(Long id);

    /**
     * 查询实验计划列表
     *
     * @param schoolExperimentPlanVo 实验计划
     * @return 实验计划集合
     */
    public List<SchoolExperimentPlanVo> selectSchoolExperimentPlanList(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 查询实验计划列表(管理员)
     *
     * @param schoolExperimentPlanVo 实验计划
     * @return 实验计划集合
     */
    public List<SchoolExperimentPlanVo> selectExperimentPlanListAdmin(SchoolExperimentPlanVo schoolExperimentPlanVo);

    public List<Map<String, String>> selectNameByVo(SchoolExperimentPlanVo schoolExperimentPlanVo);
    /**
     * 新增实验计划
     *
     * @param schoolExperimentPlanVo 实验计划
     * @return 结果
     */
    public int insertSchoolExperimentPlan(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 修改实验计划
     *
     * @param schoolExperimentPlan 实验计划
     * @return 结果
     */
    public int updateSchoolExperimentPlan(SchoolExperimentPlan schoolExperimentPlan);

    /**
     * 删除实验计划
     *
     * @param id 实验计划主键
     * @return 结果
     */
    public int deleteSchoolExperimentPlanById(Long id);

    /**
     * 批量删除实验计划
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolExperimentPlanByIds(Long[] ids);

    /**
     * 批量删除实验计划与班级关系
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolExperimentPlanClassByExperimentPlanIds(Long[] ids);

    /**
     * 批量新增实验计划与班级关系
     *
     * @param schoolExperimentPlanClassList 实验计划与班级关系列表
     * @return 结果
     */
    public int batchSchoolExperimentPlanClass(List<SchoolExperimentPlanClass> schoolExperimentPlanClassList);


    /**
     * 通过实验计划主键删除实验计划与班级关系信息
     *
     * @param id 实验计划ID
     * @return 结果
     */
    public int deleteSchoolExperimentPlanClassByExperimentPlanId(Long id);

    /**
     * 根据学年查询级部下拉框
     * @param schoolYear
     * @return
     */
    List<Map<String, Object>> getGrade(@Param("schoolYear") int schoolYear,@Param("userId") Long userId);

    /**
     * 根据级部查询对应班级
     * @param gradeId
     * @return
     */
    List<Map<String, Object>> getSchoolClass(@Param("gradeId") Long gradeId);

    /**
     * 实验室管理-级部实验计划查看列表
     * @param schoolExperimentPlanVo
     * @return
     */
    List<SchoolExperimentPlanVo> getExperimentList(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 领导-查看实验室完成情况列表
     * @param schoolExperimentPlanVo
     * @return
     */
    List<Map<String, Object>> countExperiment(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 查看实验室完成情况列表(管理员)
     * @param schoolExperimentPlanVo
     * @return
     */
    List<Map<String, Object>> countExperimentListAdmin(SchoolExperimentPlanVo schoolExperimentPlanVo);
}
