package yangtz.cs.liu.campus.mapper.schoolInstrument;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrumentClassify;

import java.util.List;

/**
 * 仪器药品分类Mapper接口
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Repository
public interface SchoolInstrumentClassifyMapper extends BaseMapper<SchoolInstrumentClassify> {
    /**
     * 查询仪器药品分类
     *
     * @param id 仪器药品分类主键
     * @return 仪器药品分类
     */
    public SchoolInstrumentClassify selectSchoolInstrumentClassifyById(Long id);

    /**
     * 查询仪器药品分类列表
     *
     * @param schoolInstrumentClassify 仪器药品分类
     * @return 仪器药品分类集合
     */
    public List<SchoolInstrumentClassify> selectSchoolInstrumentClassifyList(SchoolInstrumentClassify schoolInstrumentClassify);

    /**
     * 新增仪器药品分类
     *
     * @param schoolInstrumentClassify 仪器药品分类
     * @return 结果
     */
    public int insertSchoolInstrumentClassify(SchoolInstrumentClassify schoolInstrumentClassify);

    /**
     * 修改仪器药品分类
     *
     * @param schoolInstrumentClassify 仪器药品分类
     * @return 结果
     */
    public int updateSchoolInstrumentClassify(SchoolInstrumentClassify schoolInstrumentClassify);

    /**
     * 删除仪器药品分类
     *
     * @param id 仪器药品分类主键
     * @return 结果
     */
    public int deleteSchoolInstrumentClassifyById(Long id);

    /**
     * 批量删除仪器药品分类
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolInstrumentClassifyByIds(Long[] ids);
}
