package yangtz.cs.liu.campus.mapper.schoolEquipment;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolCirculation;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveQuery;

@Mapper
public interface CirculationMapper extends BaseMapper<SchoolCirculation> {
    /*
     * 查看设备借出归还列表
     * @param schoolCirculationVo
     * @return
     */
    List<SchoolCirculationVo> selectSchoolCirculationVoList(SchoolCirculationVo schoolCirculationVo);

    /**
     * 查看个人设备借出归还列表
     * @param schoolCirculationVo
     * @return
     */
    List<SchoolCirculationVo> selectSchoolCirculationVoListGr(SchoolCirculationVo schoolCirculationVo);


    /**
     * 查看设备借出归还详细信息
     * @param id
     * @return
     */
    SchoolCirculationVo selectSchoolCirculationVoById(Long id);

    /**
     * 删除设备借出归还详细信息
     * @param ids
     * @return
     */
    int deleteSchoolCirculationByIds(Long[] ids);


  List<SchoolCirculationVo> getReturningEquipmentByadminId(SchoolReceiveQuery schoolReceiveQuery);


  @Select(" SELECT el.encode,sc.equipment_id,el.equipment_name,el.model,sc.borrow_time ,sc.borrow_by, sc.purpose,sc.deadline ,\n"
      + "sc.return_equipment_condition,sc.return_time,sc.remark  FROM school_circulation sc LEFT JOIN school_equipment_ledger el on sc.equipment_id = el.id\n"
      + "WHERE sc.id =#{id} and  sc.del_flag=0 ")
  SchoolCirculationVo getSchoolCirculationVoById(@Param("id")Long id);


  @Select("SELECT sc.id,el.encode,sc.equipment_id,el.equipment_name,el.model,sc.borrow_time,sc.borrow_by_id,sc.borrow_by,sc.purpose,sc.deadline,sc.return_state,sc.yjuse_time,sc.sjuse_time,el.is_lend,sc.return_time,sc.return_equipment_condition,sc.received_by_id,sc.received_by,sc.yjuse_time,sc.sjuse_time,sc.remark from school_equipment_ledger el LEFT JOIN school_circulation sc on el.id = sc.equipment_id \n"
      + "WHERE  el.encode = #{encode}   AND sc.return_state=0 and el.del_flag=0")
  SchoolCirculationVo getSchoolCirculationVoByenCode(@Param("encode")String encode);


    @Select("SELECT sc.id,el.encode,sc.equipment_id,el.equipment_name,sc.return_equipment_condition ,el.model,sc.borrow_time,sc.borrow_by_id,sc.borrow_by,sc.purpose,sc.deadline,sc.return_state,el.is_lend,sc.return_time,sc.return_equipment_condition,sc.received_by_id,sc.received_by,sc.yjuse_time,sc.sjuse_time,sc.remark from  school_circulation sc LEFT JOIN school_equipment_ledger el  on el.id = sc.equipment_id  WHERE  sc.id=#{id} and el.del_flag=0")
    SchoolCirculationVo getReturningEquipmentById(@Param("id")String id);

}
