package yangtz.cs.liu.campus.mapper.interest;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesChild;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.vo.interest.ChildVO;

/**
 * 兴趣班学生Mapper接口
 * 
 * @author ruoyi
 * @date 2022-10-09
 */
@Mapper
public interface SchoolInterestClassesChildMapper extends BaseMapper<SchoolInterestClassesChild>
{
    /**
     * 查出当前培训下所有学员
     */
    public List<ChildVO> queryList(SchoolInterestClassesChild schoolInterestClassesChild);

    /**
     * 查出当前培训下所有学员id
     */
    List<Long> selectAllStudentIdByInterestClassesId(Long interestClassesId);

    /**
     * 挂载到当前兴趣班
     */
    int insertChilds(@Param("childList") List<SchoolInterestClassesChild> childList);

    /**
   新增列表查询
    */
    List<SchoolStudent> selectAddList(@Param("studentIdList") List<Long> studentIdList , @Param("student") SchoolStudent student);

    /**
   查学员
    */
    SchoolInterestClassesChild selectInterestChild(@Param("interestClassesId") Long interestClassesId, @Param("idCard") String idCard);


}
