package yangtz.cs.liu.campus.mapper.exam;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;
import yangtz.cs.liu.campus.domain.exam.ExamMain;
import yangtz.cs.liu.campus.vo.exam.ExamMainVo;

import java.util.List;

@Mapper
public interface ExamMainMapper extends BaseMapper<ExamMain> {
    /**
     * 查询参与情况
     *
     * @param exam
     * @return
     */
    List<ExamMainVo> selectTakeExamPeoNumList(ExamMainVo exam);

    /**
     * 查询代办任务
     *
     * @param examMainVo
     * @return
     */
    List<ExamMainVo> selectExamTasks(ExamMainVo examMainVo);


    String selectExamName(Long examId);

    int selectDetails(Long id);

    /**
     * 查询问卷管理
     * @param id
     * @return
     */
    ExamMain selectExamByExamId(Long id);

    /**
     * 更改问卷状态
     * @param examState
     * @param id
     * @return
     */
    int editExamState(@Param("examState") Character examState,@Param("id") Long id);

    /**
     * 问卷列表
     */
    List<ExamMainVo> getExam(@Param("userId") Long userId,@Param("examMainVo") ExamMainVo examMainVo);

    //待办问卷调查数
    int getTodoTotal(Long userId);
}
