package yangtz.cs.liu.campus.mapper.exam;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.exam.ExamDetail;
import yangtz.cs.liu.campus.vo.exam.ExamDetailVo;

import java.util.List;

@Mapper
public interface ExamDetailMapper extends BaseMapper<ExamDetail> {

    /**
     * 查询试题详细列表
     *
     * @param examDetail 试题详细
     * @return 试题详细集合
     */
    List<ExamDetail> selectExamDetailList(ExamDetail examDetail);


    /**
     * 新增试题详细
     *
     * @param examDetail 试题详细
     * @return 结果
     */
    int insertExamDetail(ExamDetail examDetail);

    /**
     * 修改试题详细
     *
     * @param examDetail 试题详细
     * @return 结果
     */
    int updateExamDetail(ExamDetail examDetail);


    List<ExamDetailVo> selectResult(@Param("examId") Long examId);
}
