package yangtz.cs.liu.campus.mapper.curricula;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysDictType;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.curricula.CurriculaSub;
import yangtz.cs.liu.campus.domain.curricula.CurriculaVariable;
import yangtz.cs.liu.campus.vo.curricula.CurriculaVariableVo;

import java.util.List;
import java.util.Map;

public interface CurriculaVariableMapper extends BaseMapper<CurriculaVariable>
{
    /**
     * 新增选课任务
     * @param curriculaVariableVo
     * @return
     */
    int insertCurriculaVariable(CurriculaVariableVo curriculaVariableVo);

    /**
     * 通过级部查询学生id集合
     * @param grade
     * @return
     */
    List<Long> selectByGrade(@Param("grade") String grade);

    /**
     * 获取班级下拉框
     * @param grade
     * @return
     */
    List<Map<String,String>> selectClass(@Param("grade") String grade);

    /**
     * 获取选课任务下拉框
     * @return
     */
    List<Map<String, String>> getGrade(@Param("teacherId") Long teacherId);

    /**
     * 获取春季，夏季，艺体科目
     * @return
     */
    List<SysDictType> selectXkTypeList();

    /**
     * 查询选课与科目关系列表
     * @return
     */
    List<CurriculaSub> selectCurriculaSubList(CurriculaSub curriculaSub);

    /**
     * 删除选课与科目关系
     * @param curriculaId
     * @return
     */
    int deleteCurriculaSubByCurriculaId(@Param("curriculaId") Long curriculaId);

    /**
     * 批量删除选课与科目关系
     * @param ids
     * @return
     */
    int deleteCurriculaSubByCurriculaIds(Long[] ids);

    /**
     * 批量新增选课与科目关系
     * @param cjkmList1
     */
    void batchInsetCurriculaSubs(List<CurriculaSub> cjkmList1);
}
