package yangtz.cs.liu.campus.domain.time;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;
@Data
public class SchoolTimeDetail extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** shooltime主键 */
    private Long schoolTimeId;

    /** 序号 */
    //@Excel(name = "序号")
    private Integer sortId;

    /** 序号名称 */
    @Excel(name = "名称")
    private String sortName;

    /** 开始时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "开始时间", width = 30, dateFormat = "HH:mm")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "结束时间", width = 30, dateFormat = "HH:mm")
    private Date endTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
