package yangtz.cs.liu.campus.domain.time;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.course.SchoolCourse;
import yangtz.cs.liu.campus.vo.Course.SchoolCourseVO;

import java.util.Date;

/**
 * 学校课程时间表
 */
@Data
public class SchoolCourseSchedule{
    private static final long serialVersionUID = 1L;

    /** 年级 */
    @Excel(name = "年级(必填)")
    private Integer gradeValue;
    /** 班级 */

    @Excel(name = "班级(必填)")
    private Integer classValue;

    /** shool_time_detail中的序号 */
    @Excel(name = "课时排序(必填)")
    private Integer timeSort;

    /** 课时 */
    @Excel(name = "课时")
    private String sortName;

    /** 开始时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "开始时间", width = 30, dateFormat = "HH:mm")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "HH:mm")
    @Excel(name = "结束时间", width = 30, dateFormat = "HH:mm")
    private Date endTime;

    /** 课时时间 */
    @Excel(name = "课时时间")
    private String sortTimeAll;

    /** 周一 */
    @Excel(name = "周一")
    private SchoolCourseVO monday;

    /** 周二 */
    @Excel(name = "周二")
    private SchoolCourseVO tuesday;

    /** 周三 */
    @Excel(name = "周三")
    private SchoolCourseVO wednesday;

    /** 周四 */
    @Excel(name = "周四")
    private SchoolCourseVO thursday;

    /** 周五 */
    @Excel(name = "周五")
    private SchoolCourseVO friday;

    /** 周六 */
    @Excel(name = "周六")
    private SchoolCourseVO saturday;

    /** 周日 */
    @Excel(name = "周日")
    private SchoolCourseVO sunday;
}
