package yangtz.cs.liu.campus.domain.thesis;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 论文情况对象 thesis
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public class Thesis extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 教师id */
    private Long teacherId;

    /** 教师姓名 */
    @Excel(name = "教师姓名")
    private String teacherName;

    /** 论文名称 */
    @Excel(name = "论文名称")
    private String thesisName;

    /** 级别（1国家级，2省级，3市级） */
    @Excel(name = "级别", readConverterExp = "1=国家级，2省级，3市级")
    private String level;

    /** 等级（1一等奖，2二等奖，3三等奖） */
    @Excel(name = "等级", readConverterExp = "1=一等奖，2二等奖，3三等奖")
    private String grade;

    /** 发表时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "发表时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date publishTime;

    /** 附件信息信息 */
    private List<SchoolAccessory> schoolAccessoryList;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setTeacherId(Long teacherId)
    {
        this.teacherId = teacherId;
    }

    public Long getTeacherId()
    {
        return teacherId;
    }
    public void setTeacherName(String teacherName)
    {
        this.teacherName = teacherName;
    }

    public String getTeacherName()
    {
        return teacherName;
    }
    public void setThesisName(String thesisName)
    {
        this.thesisName = thesisName;
    }

    public String getThesisName()
    {
        return thesisName;
    }
    public void setLevel(String level)
    {
        this.level = level;
    }

    public String getLevel()
    {
        return level;
    }
    public void setGrade(String grade)
    {
        this.grade = grade;
    }

    public String getGrade()
    {
        return grade;
    }
    public void setPublishTime(Date publishTime)
    {
        this.publishTime = publishTime;
    }

    public Date getPublishTime()
    {
        return publishTime;
    }

    public List<SchoolAccessory> getSchoolAccessoryList()
    {
        return schoolAccessoryList;
    }

    public void setSchoolAccessoryList(List<SchoolAccessory> schoolAccessoryList)
    {
        this.schoolAccessoryList = schoolAccessoryList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("teacherId", getTeacherId())
                .append("teacherName", getTeacherName())
                .append("thesisName", getThesisName())
                .append("level", getLevel())
                .append("grade", getGrade())
                .append("publishTime", getPublishTime())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("schoolAccessoryList", getSchoolAccessoryList())
                .toString();
    }
}
