package yangtz.cs.liu.campus.domain.teacherFiles;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * 教室档案通知对象 teacher_files_notice
 * 
 * @author ruoyi
 * @date 2023-09-05
 */
@Data
public class TeacherFilesNoticeTotal extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private String id;

    /** 范围 */
    @Excel(name = "范围")
    private String noticeRange;

    /** 学年 */
    private String noticeYear;

    /** 学期 */
    private String noticeSemester;

    /** 通知名称 */
    @Excel(name = "通知名称")
    private String noticeName;

    /** 状态 */
    @Excel(name = "状态（1未发布 2已发布 3已结束）")
    private String noticeState;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    @Excel(name = "教师人数")
    private Integer total;

    @Excel(name = "填写人数")
    private Integer txtotal;

    @Excel(name = "级部确认")
    private Integer tgtotal;
}
