package yangtz.cs.liu.campus.domain.teacherFiles;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

import java.util.Date;
import java.util.List;

/**
 * 教师档案课题编写情况对象 teacher_files_material
 * 
 * @author ruoyi
 * @date 2023-09-08
 */
public class TeacherFilesMaterial extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 原id */
    @Excel(name = "原id")
    private Long tId;

    /** 档案id */
    @Excel(name = "档案id")
    private Long filesId;

    /** 名称 */
    @Excel(name = "名称")
    private String name;

    /** 发表时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "发表时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date publishTime;

    private List<SchoolAccessory> accessories;

    public List<SchoolAccessory> getAccessories() {
        return accessories;
    }

    public void setAccessories(List<SchoolAccessory> accessories) {
        this.accessories = accessories;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void settId(Long tId) 
    {
        this.tId = tId;
    }

    public Long gettId() 
    {
        return tId;
    }
    public void setFilesId(Long filesId) 
    {
        this.filesId = filesId;
    }

    public Long getFilesId() 
    {
        return filesId;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setPublishTime(Date publishTime) 
    {
        this.publishTime = publishTime;
    }

    public Date getPublishTime() 
    {
        return publishTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("tId", gettId())
            .append("filesId", getFilesId())
            .append("name", getName())
            .append("publishTime", getPublishTime())
            .toString();
    }
}
