package yangtz.cs.liu.campus.domain.teacherFiles;

import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 教师电子档案导出对象
 */
@Data
public class SchoolTeacherBasiclnExport {

    /**
     * 选中导出参数
     */
    private Long[] ids;

    @Excel(name = "编号")
    private Long id;

    /**
     * 姓名
     */
    @Excel(name = "姓名")
    private String name;

    /**
     * 身份证号
     */
    @Excel(name = "身份证号")
    private String idCard;

    /**
     * 年龄  。动态查询
     */
    @Excel(name = "年龄")
    private Integer age;


    /**
     * 性别
     */
    @Excel(name = "性别", readConverterExp = "0=男,1=女,2=未知")
    private String sex;

    /**
     * 档案出生日期 (年月)
     */
    @Excel(name = "档案出生日期" ,dateFormat="yyyy-MM-dd")
    private Date fileBirthDate;


    /**
     * 档案年龄
     */
    @Excel(name = "档案年龄")
    private Integer fileAge;


    /**
     * 出生年月
     */
        @Excel(name = "出生年月")
    private String birthDate;

    /**
     * 籍贯
     */
    @Excel(name = "籍贯")
    private String hometown;

    /**
     * 民族
     */
    @Excel(name = "民族")
    private String nation;

    /**
     * 政治面貌(1中共党员、2共青团员、3群众、4民主党派成员、5无党派人士)
     */
    @Excel(name = "政治面貌" ,dictType="politics_tatusls")
    private String politicalLandscape;

    /**
     * 入党时间（年月）
     */
    @Excel(name = "入党时间" ,dateFormat="yyyy-MM-dd")
    private Date partyMembershipTime;

    /**
     * 任教学科(1语文、2数学、3英语、4物理、5化学、6生物、7政治、8历史、9地理、10音乐、11体育、12美术、13技术、14心理、15书法)
     */
    @Excel(name = "任教学科" ,dictType= "teaching_subjects")
    private String teachingSubject;

    /**
     * 现职称(1无、2初级、3中级、4副高、5正高)
     */
    @Excel(name = "现职称" ,dictType= "current_professional")
    private String currentProfessionalTitle;

    /**
     * 现职称取得资格时间
     */
    @Excel(name = "现职称取得时间" ,dateFormat="yyyy-MM-dd")
    private Date currentProfessionalTitleTime;

    /**
     * 现聘职称(1无、2初级、3中级、4副高、5正高)
     */
    @Excel(name = "现聘职称",dictType= "current_professional")
    private String currentHiringProfessionalTitle;

    /**
     * 现职称聘任时间
     */
    @Excel(name = "现聘职称取得时间" ,dateFormat="yyyy-MM-dd")
    private Date currentHiringProfessionalTitleTime;

    /**
     * 现聘岗位(1专业技术岗、2管理岗、3工勤岗)
     */
    @Excel(name = "现聘岗位" ,dictType= "current_position")
    private String currentPosition;

    /**
     * 现岗位等级聘任时间
     */
    @Excel(name = "现聘岗位取得时间" ,dateFormat="yyyy-MM-dd")
    private Date currentJobLevelAppointmentTime;

    /**
     * 现岗位等级(见习（三个现聘岗位都有见习这个等级 下拉框联动）、专业技术三级-专业技术十三级、
     * 管理五级-管理九级、技术工二级-技术工五级)
     */
    @Excel(name = "现岗位等级" ,dictType= "current_joblevel")
    private String currentJobLevel;


    /**
     * 职务
     */
    @Excel(name = "职务")
    private String duties;

    /**
     * 教师资格种类
     */
    @Excel(name = "教师资格种类")
    private String teacherQualificationType;

    /**
     * 教师资格证号码
     */
    @Excel(name = "教师资格证号码")
    private String teacherQualificationCertificateNum;

    /**
     * 参加工作时间
     */
    @Excel(name = "参加工作时间")
    private String workingHours;

    /**
     * 到二中工作时间
     */
    @Excel(name = "到二中工作时间" ,dateFormat="yyyy-MM-dd")
    private Date toSecondMiddleSchoolTime;

    /**
     * 二中工作年龄
     */
    @Excel(name = "到二中工作年限")
    private Integer toSecondAge;

    /**
     * 教龄起算时间
     */
    private Date lengthOfTeacherTime;

    /**
     * 工龄起算时间
     */
    private Date lengthOfServiceTime;

    /**
     * 工龄年限
     */
    private Integer seniority;

    /**
     * 在岗情况(1教学岗位、2教辅岗、3后勤岗、4管理岗、5其他岗、6退休、7行政、8内退岗、9待退岗)
     */
    @Excel(name = "在岗情况" ,dictType= "duty_situation")
    private String onDutySituation;

    /**
     * 在编情况 1在编 2合同制
     */
    private String currentSituation;

    /**
     * 毕业院校1
     */
    @Excel(name = "毕业院校1")
    private String graduationInstitution1;

    /**
     * 专业1
     */
    @Excel(name = "专业1")
    private String major1;

    /**
     * 毕业时间1 年月
     */
    @Excel(name = "毕业时间1",dateFormat="yyyy-MM-dd")
    private Date graduationTime1;

    /**
     * 毕业院校2
     */
    @Excel(name = "毕业院校2")
    private String graduationInstitution2;

    /**
     * 专业2
     */
    @Excel(name = "专业2")
    private String major2;

    /**
     * 毕业时间2年月
     */
    @Excel(name = "毕业时间2",dateFormat="yyyy-MM-dd")
    private Date graduationTime2;

    /**
     * 毕业院校3
     */
    @Excel(name = "毕业院校3")
    private String graduationInstitution3;

    /**
     * 专业3
     */
    @Excel(name = "专业3")
    private String major3;

    /**
     * 毕业时间3 年月
     */
    @Excel(name = "毕业时间3",dateFormat="yyyy-MM-dd")
    private Date graduationTime3;

    /**
     * 第一学历
     */
    @Excel(name = "第一学历")
    private String firstDegree;

    /**
     * 最后学历
     */
    @Excel(name = "最后学历")
    private String lastDegree;

    /**
     *  学位
     */
    @Excel(name = "学位")
    private String degree;

    /**
     * 工作经历
     */
    @Excel(name = "工作经历")
    private String  workExperience;

    /**\
     * 备注
     */
    @Excel(name = "备注")
    private String remark;

    /**
     * 照片名称
     */
    private String photoName;

    /**
     * 照片地址
     */
    private String photoUrl;

    /**
     * 钉钉手机号
     */
    private String ddPhone;

}
