package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;


/*
* 老师加班实体
* */
@Data
public class SchoolTeacherOvertime extends OurBaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 教师id
     */
    @NotNull(message = "老师id不能为空")
    private Long teacherId;

    /**
     * 教师姓名
     */
    @Excel(name = "教师姓名")
    @NotBlank(message = "老师姓名不能为空")
    private String teacherName;



    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始时间不能为空")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束时间不能为空")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 加班天数
     */
    @Excel(name = "加班天数")
    @NotBlank(message = "加班天数不能为空")
    private String days;

    /**
     * 加班原因
     */
    @Excel(name = "加班原因")
//    @NotBlank(message = "加班原因不能为空")
    private String reason;

    /**
     * 状态
     */
    private String state;
    /**
     * 流程实例ID
     **/
    private String instanceId;
    /**
     * 类型
     **/
    private String type;
    /**
     * 申请人姓名
     **/
    private String applyUser;

    /**
     * 实际开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date realityStartTime;

    /**
     * 实际结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date realityEndTime;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;

    /**
     * 审批人 id
     */
//    @NotNull(message = "审批人不能为空")
    private Long handUserId;

}
