package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/*
* 老师请假信息实体
* */
@Data
public class SchoolTeacherLeave extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 请假类型
     */
    @NotBlank(message = "请假类型不能为空")
    private String type;

    /**
     * 标题
     */
    @NotBlank(message = "标题不能为空")
    private String title;

    /**
     * 老师id
     */
    @NotNull(message = "老师id不能为空")
    private Long teacherId;

    /**
     * 老师名称
     */
    @Excel(name = "老师名称")
    @NotBlank(message = "老师名称不能为空")
    private String teacherName;

    /**
     * 请假原因
     */
    @Excel(name = "请假原因")
    @NotBlank(message = "请假原因不能为空")
    private String reasonForLeave;

    /**
     * 请假开始时间
     */

    @Excel(name = "请假开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "请假开始时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 请假开始节次（1-8）
     */
    @Excel(name = "请假开始节次（1-8）")
    private String startSort;

    /**
     * 请假结束时间
     */

    @Excel(name = "请假结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "请假结束时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 请假结束节次（1-8）
     */
    @Excel(name = "请假结束节次（1-8）")
    private String endSort;

    /**
     * 状态
     */
    private String state;


    /**
     * 请假时长,单位天
     */
//    @Excel(name = "请假时长，单位秒")
    @NotNull(message = "请假时长不能为空")
    private Double totalTime;

    /**
     * 流程实例ID
     */
//    @Excel(name = "流程实例ID")
    private String instanceId;

    /**
     * 申请人
     */
    private String applyUser;

    /** 申请人id */
    private Long applyUserId;

    /**
     * 申请时间
     */
//    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;

    /**
     * 申请人类型（0教工 1职工）
     */
    private String applyType;

    /**
     * 申请人级部/处室
     */
    @NotNull(message = "申请人级部/处室不能为空")
    private Long applyOrgid;

    /** 申请人级部/处室名称 */
    @NotBlank(message = "申请人级部/处室名称不能为空")
    private String applyOrgname;

    /**
     * 审批人 id1
     */
//    @NotNull(message = "级部/处室主任id不能为空")
    private Long handUserId1;

    /** 审批人名字1 */
    @NotBlank(message = "级部/处室主任名称不能为空")
    private String handUserName1;

    /**
     * 审批人 id2
     */
//    @NotNull(message = "审批人不能为空")
    private Long handUserId2;

    /** 审批人名字2 */
    private String handUserName2;

    /**
     * 审批人 id3
     */
//    @NotNull(message = "审批人不能为空")
    private Long handUserId3;

    /** 审批人名字3 */
    private String handUserName3;
}
