package yangtz.cs.liu.campus.domain.studentTurnover;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 异动管理对象 student_turnover
 *
 * @author wengxiulin
 * @date 2023-02-20
 */
@Data
public class StudentTurnover extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 变更类型（0转入 1转入借读 2转出 3转出借读 4退学/注销学籍 5休学 6复学） */
    @Excel(name = "变更类型", readConverterExp = "0=转入,1=转入借读,2=转出,3=转出借读,4=退学/注销学籍,5=休学,6=复学")
    private String changeType;

    /** 学生身份证 */
    @Excel(name = "学生身份证")
    private String idCard;

    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 监护人关系（0父亲 1母亲 2爷爷 3 奶奶 4叔叔 5姑姑） */
    @Excel(name = "监护人关系", readConverterExp = "0=父亲,1=母亲,2=爷爷,3=,奶=奶,4=叔叔,5=姑姑")
    private String relationship;

    /** 性别（0男 1女） */
    @Excel(name = "性别", readConverterExp = "0=男,1=女")
    private String sex;

    /** 出生年月 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出生年月", width = 30, dateFormat = "yyyy-MM-dd")
    private Date birthday;

    /** 年级班级id */
    @Excel(name = "年级班级id")
    private Long classId;

    /** 学号 */
    @Excel(name = "学号")
    private String nationalNumber;

    /** 家长姓名 */
    @Excel(name = "家长姓名")
    private String parentName;

    /** 住址 */
    @Excel(name = "住址")
    private String homeAddress;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String telephone;

    /** 是否保留（0是1否） */
    @Excel(name = "是否保留", readConverterExp = "0=是1否")
    private String isSave;

    /** 转出（入）学校 */
    @Excel(name = "转出（入）学校")
    private String turnSchool;

    /** 办结时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "办结时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 状态（0审批中 1终止 2办结） */
    @Excel(name = "状态", readConverterExp = "0=审批中,1=终止,2=办结")
    private String state;

    /** 附件地址 */
    @Excel(name = "附件地址")
    private String dataUrl;

    /** 附件名称 */
    @Excel(name = "附件名称")
    private String dataName;

    /** 学生id */
    @Excel(name = "学生id")
    private Long studentId;
}
