package yangtz.cs.liu.campus.domain.studentChange;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 学生关键信息变更对象 student_info_change
 *
 * @author wengxiulin
 * @date 2023-02-20
 */
@Data
public class StudentInfoChange extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;


    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 民族 */
    @Excel(name = "民族")
    private String nation;

    /** 学生身份证 */
    @Excel(name = "学生身份证")
    private String idCard;

    /** 变更后学生姓名 */
    @Excel(name = "变更后学生姓名")
    private String newStudentName;

    /** 变更后民族 */
    @Excel(name = "变更后民族")
    private String newNation;

    /** 变更后学生身份证 */
    @Excel(name = "变更后学生身份证")
    private String newIdCard;

    /** 附件地址 */
    @Excel(name = "附件地址")
    private String dataUrl;

    /** 附件名称 */
    @Excel(name = "附件名称")
    private String dataName;

    /** 学生id */
    @Excel(name = "学生id")
    private Long studentId;

    /** 提交时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "提交时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date submitTime;

    /** 提交状态（0未提交 1已提交） */
    @Excel(name = "提交状态", readConverterExp = "0=未提交,1=已提交")
    private String state;
}
