package yangtz.cs.liu.campus.domain.student;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class SchoolStudentEvaluate extends OurBaseEntity {

    /** 学生id */
    @NotNull(message = "学生id不能为空")
    private Long studentId;

    /** 学生姓名 */
    @NotBlank(message = "学生姓名不能为空")
    @Excel(name = "学生姓名")
    private String studentName;

    /** 学期 */
//    @NotBlank(message = "学期不能为空")
    @Excel(name = "学期")
    private String semester;

    /** 班主任评语 */
    @Excel(name = "班主任评语")
    private String evaluate;

    /** 分值 */
    @Excel(name = "分值")
//    @NotNull(message = "分值不能为空")
    private Integer score;

    /** 自我评价 */
    @Excel(name = "自我评价")
    private String studentComment;

    /** 学业测评 */
    @Excel(name = "学业测评")
    private String academicEvaluation;

    /** 日常点评 */
    @Excel(name = "日常点评")
    private String dailyComments;

    /** 体质测评 */
    @Excel(name = "体质测评")
    private String physiqueEvaluation;
}
