package yangtz.cs.liu.campus.domain.student;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 学生对象 school_student
 *
 * @author hxz
 * @date 2023-02-26
 */
public class SchoolStudentEducational extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 班级id */
    @Excel(name = "班级id")
    private Long gradeId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 性别 */
    @Excel(name = "性别")
    private String sex;

    /** 出生日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出生日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date birthday;

    /** 民族 */
    @Excel(name = "民族")
    private String nation;

    /** 家庭住址 */
    @Excel(name = "家庭住址")
    private String homeAddress;

    /** 籍贯 */
    @Excel(name = "籍贯")
    private String nativePlace;

    /** 学年 */
    @Excel(name = "学年")
    private Long schoolYear;

    /** 年级 */
    @Excel(name = "年级")
    private Long grade;

    /** 班级 */
    @Excel(name = "班级")
    private Long classes;

    /** 禁忌食物 */
    @Excel(name = "禁忌食物")
    private String tabooFood;

    /** 图片路径 */
    @Excel(name = "图片路径")
    private String avatar;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 学号 */
    @Excel(name = "学号")
    private String schoolNo;

    /** 学生状态:1正常、2休学、3毕业、4肄业、5毕业、6其他 */
    @Excel(name = "学生状态:1正常、2休学、3毕业、4肄业、5毕业、6其他")
    private String studentStatus;

    /** 学生类型:1本校生、2借读生 */
    @Excel(name = "学生类型:1本校生、2借读生")
    private String studentType;

    /** 校园一卡通 */
    @Excel(name = "校园一卡通")
    private String oneCard;

    /** $column.columnComment */
    private String delFlag;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setGradeId(Long gradeId)
    {
        this.gradeId = gradeId;
    }

    public Long getGradeId()
    {
        return gradeId;
    }
    public void setStudentName(String studentName)
    {
        this.studentName = studentName;
    }

    public String getStudentName()
    {
        return studentName;
    }
    public void setSex(String sex)
    {
        this.sex = sex;
    }

    public String getSex()
    {
        return sex;
    }
    public void setBirthday(Date birthday)
    {
        this.birthday = birthday;
    }

    public Date getBirthday()
    {
        return birthday;
    }
    public void setNation(String nation)
    {
        this.nation = nation;
    }

    public String getNation()
    {
        return nation;
    }
    public void setHomeAddress(String homeAddress)
    {
        this.homeAddress = homeAddress;
    }

    public String getHomeAddress()
    {
        return homeAddress;
    }
    public void setNativePlace(String nativePlace)
    {
        this.nativePlace = nativePlace;
    }

    public String getNativePlace()
    {
        return nativePlace;
    }
    public void setSchoolYear(Long schoolYear)
    {
        this.schoolYear = schoolYear;
    }

    public Long getSchoolYear()
    {
        return schoolYear;
    }
    public void setGrade(Long grade)
    {
        this.grade = grade;
    }

    public Long getGrade()
    {
        return grade;
    }
    public void setClasses(Long classes)
    {
        this.classes = classes;
    }

    public Long getClasses()
    {
        return classes;
    }
    public void setTabooFood(String tabooFood)
    {
        this.tabooFood = tabooFood;
    }

    public String getTabooFood()
    {
        return tabooFood;
    }
    public void setAvatar(String avatar)
    {
        this.avatar = avatar;
    }

    public String getAvatar()
    {
        return avatar;
    }
    public void setIdCard(String idCard)
    {
        this.idCard = idCard;
    }

    public String getIdCard()
    {
        return idCard;
    }
    public void setSchoolNo(String schoolNo)
    {
        this.schoolNo = schoolNo;
    }

    public String getSchoolNo()
    {
        return schoolNo;
    }
    public void setStudentStatus(String studentStatus)
    {
        this.studentStatus = studentStatus;
    }

    public String getStudentStatus()
    {
        return studentStatus;
    }
    public void setStudentType(String studentType)
    {
        this.studentType = studentType;
    }

    public String getStudentType()
    {
        return studentType;
    }
    public void setOneCard(String oneCard)
    {
        this.oneCard = oneCard;
    }

    public String getOneCard()
    {
        return oneCard;
    }
    public void setDelFlag(String delFlag)
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag()
    {
        return delFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("gradeId", getGradeId())
            .append("studentName", getStudentName())
            .append("sex", getSex())
            .append("birthday", getBirthday())
            .append("nation", getNation())
            .append("homeAddress", getHomeAddress())
            .append("nativePlace", getNativePlace())
            .append("schoolYear", getSchoolYear())
            .append("grade", getGrade())
            .append("classes", getClasses())
            .append("tabooFood", getTabooFood())
            .append("avatar", getAvatar())
            .append("idCard", getIdCard())
            .append("schoolNo", getSchoolNo())
            .append("studentStatus", getStudentStatus())
            .append("studentType", getStudentType())
            .append("oneCard", getOneCard())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("delFlag", getDelFlag())
            .toString();
    }
}
