package yangtz.cs.liu.campus.domain.schooloffical;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;


@Data
public class SchoolOfficial extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 发文字号
     */
    private String issuedNum;

    /**
     * 发文标题
     */
    private String issuedName;

    /**
     * 收文时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date receiveDate;

    /**
     * 办理期限
     * */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date deadline;

    /**
     * 紧急程度(0一般 1紧急 2特急)
     */
    private String urgency;

    /**
     * 简介
     */
    private String remarks;

    /**
     * 状态（0待发文 1流转中 2已完结）
     */
    private String state;
}
