package yangtz.cs.liu.campus.domain.schoolgrade;

import com.alibaba.fastjson2.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolGradeMentor extends OurBaseEntity {

    /** 老师主键 */
    @NotNull(message = "级部教师不能为空")
    private Long teacherId;

    /** 年级级部主键 */
    private Long gradeId;

    /** 教师任职开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /** 教师任职结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    /** 类型（1年级部，2学科组长） */
    private String type;

    /** 职务 */
    private String teacherPost;

    /** 学科组(1物理学科组，2化学学科组，3生物学科组) */
    private String subGroup;
}
