package yangtz.cs.liu.campus.domain.schoolSecurity;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import java.util.Date;

/**
 * 监控录像调用(内部)对象 school_video_consult
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@Data
public class SchoolVideoConsult extends OurBaseEntity
{

    /** 流程实例id */
    private String instanceId;

    /** 用户id */
    private Long userId;

    /** 用户名称 */
    private String userName;

    /** 联系电话 */
    private Long phone;

    /** 所在部门id */
    private Long orgid;

    /** 所在部门 */
    private String orgname;

    /** 录像调用开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date videoStartTime;

    /** 录像调用结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date videoEndTime;

    /** 调阅位置 */
    private String location;

    /** 申请事由 */
    private String applyReason;

    /** 状态（0未提交，1级部/处室审核，2信息技术中心负责人审核，3安全管理中心负责人审核，4分管领导审核，5结束） */
    private String state;

    /** 申请人id */
    private Long applyUserId;

    /** 申请人 */
    private String applyUser;

    /** 申请部门id */
    private Long applyOrgid;

    /** 申请部门 */
    private String applyOrgname;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 申请人类型（0教工 1职工） */
    private String applyType;

    /** 审批人id1 */
    private Long handUserId1;

    /** 审批人1 */
    private String handUserName1;

    /** 审批人1意见 */
    private String handUserOpinion1;

    /** 审批人1签名是否显示（1是，0否） */
    private String isSign1;

    /** 审批人id2 */
    private Long handUserId2;

    /** 审批人2 */
    private String handUserName2;

    /** 审批人2意见 */
    private String handUserOpinion2;

    /** 审批人2签名是否显示（1是，0否） */
    private String isSign2;

    /** 审批人id3 */
    private Long handUserId3;

    /** 审批人3 */
    private String handUserName3;

    /** 审批人3意见 */
    private String handUserOpinion3;

    /** 审批人3签名是否显示（1是，0否） */
    private String isSign3;

    /** 审批人id4 */
    private Long handUserId4;

    /** 审批人4 */
    private String handUserName4;

    /** 审批人4意见 */
    private String handUserOpinion4;

    /** 审批人4签名是否显示（1是，0否） */
    private String isSign4;

    /** 调取结果1 */
    private String fetchResult1;

    /** 调取结果2 */
    private String fetchResult2;
}
