package yangtz.cs.liu.campus.domain.schoolRewardsPunishments;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 学校获奖对象 school_sc_awards
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@Data
public class SchoolScAwards extends OurBaseEntity
{
    /** 比赛名称 */
    @Excel(name = "比赛名称")
    private String competitionName;

    /** 主办单位 */
    @Excel(name = "主办单位")
    private String organizer;

    /** 获奖名称 */
    @Excel(name = "获奖名称")
    private String awardsName;

    /** 主管部门id */
    @Excel(name = "主管部门id")
    private Long competentDeptId;

    /** 主管部门 */
    @Excel(name = "主管部门")
    private String competentDept;

    /** 获奖级别(字典) */
    @Excel(name = "获奖级别(字典)")
    private String awardsLevel;

    /** 部门主任id */
    @Excel(name = "部门主任id")
    private Long deptDirectorId;

    /** 部门主任 */
    @Excel(name = "部门主任")
    private String deptDirector;

    /** 获奖时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "获奖时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date awardsTime;

    /** 获奖类型(字典) */
    @Excel(name = "获奖类型(字典)")
    private String awardsType;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 审核状态(0未提交，1审核中，2通过，3驳回) */
    @Excel(name = "审核状态(0未提交，1审核中，2通过，3驳回)")
    private String auditState;

    /** 申请人id */
    private Long applyId;

    /** 申请人 */
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;
}
