package yangtz.cs.liu.campus.domain.schoolInstrument;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

/**
 * 仪器药品分类对象 school_instrument_classify
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Data
public class SchoolInstrumentClassify extends OurBaseEntity {

    /** 仪器类名 */
    @Excel(name = "仪器类名")
    private String instrumentTypeName;

    /** 上级分类id */
    @Excel(name = "上级分类id")
    private Long parentId;

    /** 祖级列表 */
    @Excel(name = "祖级列表")
    private String ancestors;

    /** 排序 */
    @Excel(name = "排序")
    private Integer orderNum;

    /** 是否为消耗品(1是，0否) */
    @Excel(name = "是否为消耗品",readConverterExp = ("1=是,0=否"))
    private String isConsumables;

    /** 备注 */
    private String remark;
}
